/************************************************************************************************/
/* Stata User File for H20 Data                                                                 */
/*                                                                                              */
/* This file contains information and a sample Stata program to create a permanent              */
/* Stata dataset for users who want to use Stata in processing the MEPS data provided           */
/* in this PUF release.  Stata (StataCorp) has the capability to produce                        */
/* appropriate standard errors for estimates from a survey with a complex sample                */
/* design such as the Medical Expenditure Panel Survey (MEPS).                                  */
/* The input file for creating a permanent Stata dataset is the ASCII data file                 */
/* (H20.DAT) supplied in this PUF release, which in turn can be extracted from the              */
/* .EXE file. After entering the Stata interactive environment access the Stata DO-File         */
/* editor by clicking on the appropriate icon in the command line at the top of the             */
/* screen.  Copy and paste the following Stata commands into the editor and save as a           */
/* DO file.  A DO file is a Stata program which may then be executed using the DO command.      */
/* For example, if the DO file is named H20.DO and is located in the directory                  */
/* C:\MEPS\PROG, then the file may be executed by typing the following command into             */
/* the Stata command line:                                                                      */
/*                         do C:\MEPS\PROG\H20.DO                                               */
/* The program below will output the Stata dataset H20.DTA                                      */
/************************************************************************************************/


#delimit ;
cd $datadir/MEPS/dat/fullyearconsolidated;
clear;

* INPUT ALL VARIABLES;
infix
  long   DUID 1-5
  int    PID 6-8
  str    DUPERSID 9-16
  byte   PANEL97 17-17
  str    FAMID31 18-19
  str    FAMID42 20-21
  str    FAMID53 22-23
  str    FAMID97 24-25
  str    FAMIDYR 26-27
  str    CPSFAMID 28-29
  byte   FCSZ1231 30-31
  byte   FCRP1231 32-33
  str    RULETR31 34-35
  str    RULETR42 36-37
  str    RULETR53 38-39
  str    RULETR97 40-41
  byte   RUSIZE31 42-43
  byte   RUSIZE42 44-45
  byte   RUSIZE53 46-47
  byte   RUSIZE97 48-49
  byte   RUCLAS31 50-51
  byte   RUCLAS42 52-53
  byte   RUCLAS53 54-55
  byte   RUCLAS97 56-56
  byte   FAMSZE31 57-58
  byte   FAMSZE42 59-60
  byte   FAMSZE53 61-62
  byte   FAMSZE97 63-64
  byte   FMRS1231 65-66
  byte   FAMS1231 67-68
  byte   FAMSZEYR 69-70
  byte   FAMRFPYR 71-72
  byte   FYFAMTYP 73-73
  byte   INRU1231 74-74
  byte   REGION31 75-76
  byte   REGION42 77-78
  byte   REGION53 79-80
  byte   REGION97 81-82
  byte   MSA53 83-84
  byte   MSA97 85-86
  int    REFPRS31 87-89
  int    REFPRS42 90-92
  int    REFPRS53 93-95
  int    REFPRS97 96-98
  byte   RESP31 99-99
  byte   RESP42 100-100
  byte   RESP53 101-101
  byte   RESP97 102-102
  byte   PROXY31 103-104
  byte   PROXY42 105-106
  byte   PROXY53 107-108
  byte   PROXY97 109-109
  byte   BEGRFD31 110-111
  byte   BEGRFM31 112-113
  int    BEGRFY31 114-117
  byte   ENDRFD31 118-119
  byte   ENDRFM31 120-121
  int    ENDRFY31 122-125
  byte   BEGRFD42 126-127
  byte   BEGRFM42 128-129
  int    BEGRFY42 130-133
  byte   ENDRFD42 134-135
  byte   ENDRFM42 136-137
  int    ENDRFY42 138-141
  byte   BEGRFD53 142-143
  byte   BEGRFM53 144-145
  int    BEGRFY53 146-149
  byte   ENDRFD53 150-151
  byte   ENDRFM53 152-153
  int    ENDRFY53 154-157
  byte   ENDRFD97 158-159
  byte   ENDRFM97 160-161
  int    ENDRFY97 162-165
  byte   KEYNESS 166-166
  byte   INSCOP31 167-167
  byte   INSCOP42 168-168
  byte   INSCOP53 169-169
  byte   INSCOP97 170-170
  byte   INSC1231 171-171
  byte   INSCOPE 172-172
  byte   ELGRND31 173-173
  byte   ELGRND42 174-174
  byte   ELGRND53 175-175
  byte   ELGRND97 176-176
  byte   ELIGIBLE 177-177
  byte   PSTATS31 178-179
  byte   PSTATS42 180-181
  byte   PSTATS53 182-183
  str    RURSLT31 184-185
  str    RURSLT42 186-187
  str    RURSLT53 188-189
  byte   AGE31X 190-191
  byte   AGE42X 192-193
  byte   AGE53X 194-195
  byte   AGE97X 196-197
  byte   DOBMM 198-199
  int    DOBYY 200-203
  byte   SEX 204-204
  byte   RACEX 205-206
  byte   RACETHNX 207-207
  byte   HISPANX 208-208
  byte   HISPCAT 209-210
  byte   MARRY31X 211-212
  byte   MARRY42X 213-214
  byte   MARRY53X 215-216
  byte   MARRY97X 217-218
  int    SPOUID31 219-221
  int    SPOUID42 222-224
  int    SPOUID53 225-227
  int    SPOUID97 228-230
  byte   SPOUIN31 231-232
  byte   SPOUIN42 233-234
  byte   SPOUIN53 235-236
  byte   SPOUIN97 237-238
  byte   EDUCYR31 239-240
  byte   EDUCYR42 241-242
  byte   EDUCYR53 243-244
  byte   EDUCYR97 245-246
  byte   HIDEG31 247-248
  byte   HIDEG42 249-250
  byte   HIDEG53 251-252
  byte   HIDEG97 253-254
  byte   FTSTU31X 255-256
  byte   FTSTU42X 257-258
  byte   FTSTU53X 259-260
  byte   FTSTU97X 261-262
  byte   ACTDTY31 263-264
  byte   ACTDTY42 265-266
  byte   ACTDTY53 267-268
  byte   DIDSERVE 269-270
  byte   VETPVIET 271-272
  byte   VETVIET 273-274
  byte   VETKOR 275-276
  byte   VETWW 277-278
  byte   VETOTH 279-280
  byte   RFREL31X 281-282
  byte   RFREL42X 283-284
  byte   RFREL53X 285-286
  byte   RFREL97X 287-288
  int    MOPID31X 289-291
  int    MOPID42X 292-294
  int    MOPID53X 295-297
  int    DAPID31X 298-300
  int    DAPID42X 301-303
  int    DAPID53X 304-306
  byte   SSIDIS97 307-308
  byte   AFDC97 309-310
  byte   FILEDR97 311-312
  byte   WILFIL97 313-314
  byte   FLSTAT97 315-316
  byte   FILER97 317-318
  byte   JTINRU97 319-320
  int    JNTPID97 321-323
  byte   CLMDEP97 324-325
  byte   DEPDNT97 326-327
  byte   DPINRU97 328-329
  byte   DPOTSD97 330-331
  byte   TAXFRM97 332-333
  byte   DEDUCT97 334-335
  byte   ITMEXP97 336-337
  double MEXAMT97 338-345
  double NTMDED97 346-353
  double TOTDED97 354-362
  byte   CLMHIP97 363-364
  byte   ELDISC97 365-366
  byte   EICRDT97 367-368
  int    UNEMTX97 369-371
  int    INTRTX97 372-374
  int    SSECTX97 375-377
  int    IRATAX97 378-380
  byte   FOODST97 381-382
  byte   FOODMN97 383-384
  double FOODCT97 385-391
  double FOODVL97 392-397
  double TTLP97X 398-406
  byte   POVCAT97 407-407
  double WAGEP97X 408-416
  byte   WAGIMP97 417-417
  double BUSNP97X 418-426
  byte   BUSIMP97 427-427
  double FARMP97X 428-436
  byte   FARIMP97 437-437
  double UNEMP97X 438-445
  byte   UNEIMP97 446-446
  double WCMPP97X 447-454
  byte   WCPIMP97 455-455
  double INTRP97X 456-463
  byte   INTIMP97 464-464
  double DIVDP97X 465-472
  byte   DIVIMP97 473-473
  double SALEP97X 474-482
  byte   SALIMP97 483-483
  double PENSP97X 484-491
  byte   PENIMP97 492-492
  double SSECP97X 493-500
  byte   SSCIMP97 501-501
  double TRSTP97X 502-510
  byte   TRTIMP97 511-511
  double VETSP97X 512-519
  byte   VETIMP97 520-520
  double IRASP97X 521-528
  byte   IRAIMP97 529-529
  double REFDP97X 530-536
  byte   REFIMP97 537-537
  double ALIMP97X 538-545
  byte   ALIIMP97 546-546
  double CHLDP97X 547-554
  byte   CHLIMP97 555-555
  double CASHP97X 556-563
  byte   CSHIMP97 564-564
  double SSIP97X 565-572
  byte   SSIIMP97 573-573
  double PUBP97X 574-581
  byte   PUBIMP97 582-582
  double OTHRP97X 583-590
  byte   OTHIMP97 591-591
  byte   EMPST31 592-593
  byte   EMPST42 594-595
  byte   EMPST53 596-597
  byte   RNDFLG31 598-599
  byte   MORJOB31 600-601
  byte   MORJOB42 602-603
  byte   MORJOB53 604-605
  byte   EVRWRK 606-607
  double HRWG31X 608-613
  double HRWG42X 614-619
  double HRWG53X 620-625
  byte   HRWGIM31 626-626
  byte   HRWGIM42 627-627
  byte   HRWGIM53 628-628
  byte   HRHOW31 629-630
  byte   HRHOW42 631-632
  byte   HRHOW53 633-634
  int    HOUR31 635-637
  int    HOUR42 638-640
  int    HOUR53 641-643
  byte   SELFCM31 644-645
  byte   SELFCM42 646-647
  byte   SELFCM53 648-649
  byte   DISVW31X 650-651
  byte   DISVW42X 652-653
  byte   DISVW53X 654-655
  byte   CHOIC31 656-657
  byte   CHOIC42 658-659
  byte   CHOIC53 660-661
  byte   CIND31 662-663
  byte   CIND42 664-665
  byte   CIND53 666-667
  int    NUMEMP31 668-670
  int    NUMEMP42 671-673
  int    NUMEMP53 674-676
  byte   MORE31 677-678
  byte   MORE42 679-680
  byte   MORE53 681-682
  byte   UNION31 683-684
  byte   UNION42 685-686
  byte   UNION53 687-688
  byte   NWK31 689-690
  byte   NWK42 691-692
  byte   NWK53 693-694
  byte   CHGJ3142 695-696
  byte   CHGJ4253 697-698
  byte   YCHJ3142 699-700
  byte   YCHJ4253 701-702
  byte   STJBMM31 703-704
  byte   STJBDD31 705-706
  byte   STJBYY31 707-708
  byte   STJBMM42 709-710
  byte   STJBDD42 711-712
  byte   STJBYY42 713-714
  byte   STJBMM53 715-716
  byte   STJBDD53 717-718
  byte   STJBYY53 719-720
  byte   EVRETIRE 721-722
  byte   COCCP31 723-724
  byte   COCCP42 725-726
  byte   COCCP53 727-728
  byte   BGNWK31 729-730
  byte   BGNWK42 731-732
  byte   BGNWK53 733-734
  byte   ENDWK31 735-736
  byte   ENDWK42 737-738
  byte   ENDWK53 739-740
  byte   PAYVAC31 741-742
  byte   PAYVAC42 743-744
  byte   PAYVAC53 745-746
  byte   SICPAY31 747-748
  byte   SICPAY42 749-750
  byte   SICPAY53 751-752
  byte   PAYDR31 753-754
  byte   PAYDR42 755-756
  byte   PAYDR53 757-758
  byte   RETPLN31 759-760
  byte   RETPLN42 761-762
  byte   RETPLN53 763-764
  byte   SHFTWK31 765-766
  byte   SHFTWK42 767-768
  byte   SHFTWK53 769-770
  byte   BSNTY31 771-772
  byte   BSNTY42 773-774
  byte   BSNTY53 775-776
  byte   JOBORG31 777-778
  byte   JOBORG42 779-780
  byte   JOBORG53 781-782
  byte   HELD31X 783-784
  byte   HELD42X 785-786
  byte   HELD53X 787-788
  byte   OFFER31X 789-790
  byte   OFFER42X 791-792
  byte   OFFER53X 793-794
  byte   CHJA97X 795-796
  byte   CHFE97X 797-798
  byte   CHMA97X 799-800
  byte   CHAP97X 801-802
  byte   CHMY97X 803-804
  byte   CHJU97X 805-806
  byte   CHJL97X 807-808
  byte   CHAU97X 809-810
  byte   CHSE97X 811-812
  byte   CHOC97X 813-814
  byte   CHNO97X 815-816
  byte   CHDE97X 817-818
  byte   MCRJA97 819-820
  byte   MCRFE97 821-822
  byte   MCRMA97 823-824
  byte   MCRAP97 825-826
  byte   MCRMY97 827-828
  byte   MCRJU97 829-830
  byte   MCRJL97 831-832
  byte   MCRAU97 833-834
  byte   MCRSE97 835-836
  byte   MCROC97 837-838
  byte   MCRNO97 839-840
  byte   MCRDE97 841-842
  byte   MCRJA97X 843-844
  byte   MCRFE97X 845-846
  byte   MCRMA97X 847-848
  byte   MCRAP97X 849-850
  byte   MCRMY97X 851-852
  byte   MCRJU97X 853-854
  byte   MCRJL97X 855-856
  byte   MCRAU97X 857-858
  byte   MCRSE97X 859-860
  byte   MCROC97X 861-862
  byte   MCRNO97X 863-864
  byte   MCRDE97X 865-866
  byte   MCDJA97 867-868
  byte   MCDFE97 869-870
  byte   MCDMA97 871-872
  byte   MCDAP97 873-874
  byte   MCDMY97 875-876
  byte   MCDJU97 877-878
  byte   MCDJL97 879-880
  byte   MCDAU97 881-882
  byte   MCDSE97 883-884
  byte   MCDOC97 885-886
  byte   MCDNO97 887-888
  byte   MCDDE97 889-890
  byte   MCDJA97X 891-892
  byte   MCDFE97X 893-894
  byte   MCDMA97X 895-896
  byte   MCDAP97X 897-898
  byte   MCDMY97X 899-900
  byte   MCDJU97X 901-902
  byte   MCDJL97X 903-904
  byte   MCDAU97X 905-906
  byte   MCDSE97X 907-908
  byte   MCDOC97X 909-910
  byte   MCDNO97X 911-912
  byte   MCDDE97X 913-914
  byte   OPAJA97 915-916
  byte   OPAFE97 917-918
  byte   OPAMA97 919-920
  byte   OPAAP97 921-922
  byte   OPAMY97 923-924
  byte   OPAJU97 925-926
  byte   OPAJL97 927-928
  byte   OPAAU97 929-930
  byte   OPASE97 931-932
  byte   OPAOC97 933-934
  byte   OPANO97 935-936
  byte   OPADE97 937-938
  byte   OPBJA97 939-940
  byte   OPBFE97 941-942
  byte   OPBMA97 943-944
  byte   OPBAP97 945-946
  byte   OPBMY97 947-948
  byte   OPBJU97 949-950
  byte   OPBJL97 951-952
  byte   OPBAU97 953-954
  byte   OPBSE97 955-956
  byte   OPBOC97 957-958
  byte   OPBNO97 959-960
  byte   OPBDE97 961-962
  byte   STAJA97 963-964
  byte   STAFE97 965-966
  byte   STAMA97 967-968
  byte   STAAP97 969-970
  byte   STAMY97 971-972
  byte   STAJU97 973-974
  byte   STAJL97 975-976
  byte   STAAU97 977-978
  byte   STASE97 979-980
  byte   STAOC97 981-982
  byte   STANO97 983-984
  byte   STADE97 985-986
  byte   PUBJA97X 987-988
  byte   PUBFE97X 989-990
  byte   PUBMA97X 991-992
  byte   PUBAP97X 993-994
  byte   PUBMY97X 995-996
  byte   PUBJU97X 997-998
  byte   PUBJL97X 999-1000
  byte   PUBAU97X 1001-1002
  byte   PUBSE97X 1003-1004
  byte   PUBOC97X 1005-1006
  byte   PUBNO97X 1007-1008
  byte   PUBDE97X 1009-1010
  byte   PEGJA97 1011-1012
  byte   PEGFE97 1013-1014
  byte   PEGMA97 1015-1016
  byte   PEGAP97 1017-1018
  byte   PEGMY97 1019-1020
  byte   PEGJU97 1021-1022
  byte   PEGJL97 1023-1024
  byte   PEGAU97 1025-1026
  byte   PEGSE97 1027-1028
  byte   PEGOC97 1029-1030
  byte   PEGNO97 1031-1032
  byte   PEGDE97 1033-1034
  byte   PDKJA97 1035-1036
  byte   PDKFE97 1037-1038
  byte   PDKMA97 1039-1040
  byte   PDKAP97 1041-1042
  byte   PDKMY97 1043-1044
  byte   PDKJU97 1045-1046
  byte   PDKJL97 1047-1048
  byte   PDKAU97 1049-1050
  byte   PDKSE97 1051-1052
  byte   PDKOC97 1053-1054
  byte   PDKNO97 1055-1056
  byte   PDKDE97 1057-1058
  byte   PNGJA97 1059-1060
  byte   PNGFE97 1061-1062
  byte   PNGMA97 1063-1064
  byte   PNGAP97 1065-1066
  byte   PNGMY97 1067-1068
  byte   PNGJU97 1069-1070
  byte   PNGJL97 1071-1072
  byte   PNGAU97 1073-1074
  byte   PNGSE97 1075-1076
  byte   PNGOC97 1077-1078
  byte   PNGNO97 1079-1080
  byte   PNGDE97 1081-1082
  byte   POGJA97 1083-1084
  byte   POGFE97 1085-1086
  byte   POGMA97 1087-1088
  byte   POGAP97 1089-1090
  byte   POGMY97 1091-1092
  byte   POGJU97 1093-1094
  byte   POGJL97 1095-1096
  byte   POGAU97 1097-1098
  byte   POGSE97 1099-1100
  byte   POGOC97 1101-1102
  byte   POGNO97 1103-1104
  byte   POGDE97 1105-1106
  byte   PRSJA97 1107-1108
  byte   PRSFE97 1109-1110
  byte   PRSMA97 1111-1112
  byte   PRSAP97 1113-1114
  byte   PRSMY97 1115-1116
  byte   PRSJU97 1117-1118
  byte   PRSJL97 1119-1120
  byte   PRSAU97 1121-1122
  byte   PRSSE97 1123-1124
  byte   PRSOC97 1125-1126
  byte   PRSNO97 1127-1128
  byte   PRSDE97 1129-1130
  byte   POUJA97 1131-1132
  byte   POUFE97 1133-1134
  byte   POUMA97 1135-1136
  byte   POUAP97 1137-1138
  byte   POUMY97 1139-1140
  byte   POUJU97 1141-1142
  byte   POUJL97 1143-1144
  byte   POUAU97 1145-1146
  byte   POUSE97 1147-1148
  byte   POUOC97 1149-1150
  byte   POUNO97 1151-1152
  byte   POUDE97 1153-1154
  byte   PRIJA97 1155-1156
  byte   PRIFE97 1157-1158
  byte   PRIMA97 1159-1160
  byte   PRIAP97 1161-1162
  byte   PRIMY97 1163-1164
  byte   PRIJU97 1165-1166
  byte   PRIJL97 1167-1168
  byte   PRIAU97 1169-1170
  byte   PRISE97 1171-1172
  byte   PRIOC97 1173-1174
  byte   PRINO97 1175-1176
  byte   PRIDE97 1177-1178
  byte   HPEJA97 1179-1180
  byte   HPEFE97 1181-1182
  byte   HPEMA97 1183-1184
  byte   HPEAP97 1185-1186
  byte   HPEMY97 1187-1188
  byte   HPEJU97 1189-1190
  byte   HPEJL97 1191-1192
  byte   HPEAU97 1193-1194
  byte   HPESE97 1195-1196
  byte   HPEOC97 1197-1198
  byte   HPENO97 1199-1200
  byte   HPEDE97 1201-1202
  byte   HPDJA97 1203-1204
  byte   HPDFE97 1205-1206
  byte   HPDMA97 1207-1208
  byte   HPDAP97 1209-1210
  byte   HPDMY97 1211-1212
  byte   HPDJU97 1213-1214
  byte   HPDJL97 1215-1216
  byte   HPDAU97 1217-1218
  byte   HPDSE97 1219-1220
  byte   HPDOC97 1221-1222
  byte   HPDNO97 1223-1224
  byte   HPDDE97 1225-1226
  byte   HPNJA97 1227-1228
  byte   HPNFE97 1229-1230
  byte   HPNMA97 1231-1232
  byte   HPNAP97 1233-1234
  byte   HPNMY97 1235-1236
  byte   HPNJU97 1237-1238
  byte   HPNJL97 1239-1240
  byte   HPNAU97 1241-1242
  byte   HPNSE97 1243-1244
  byte   HPNOC97 1245-1246
  byte   HPNNO97 1247-1248
  byte   HPNDE97 1249-1250
  byte   HPOJA97 1251-1252
  byte   HPOFE97 1253-1254
  byte   HPOMA97 1255-1256
  byte   HPOAP97 1257-1258
  byte   HPOMY97 1259-1260
  byte   HPOJU97 1261-1262
  byte   HPOJL97 1263-1264
  byte   HPOAU97 1265-1266
  byte   HPOSE97 1267-1268
  byte   HPOOC97 1269-1270
  byte   HPONO97 1271-1272
  byte   HPODE97 1273-1274
  byte   HPSJA97 1275-1276
  byte   HPSFE97 1277-1278
  byte   HPSMA97 1279-1280
  byte   HPSAP97 1281-1282
  byte   HPSMY97 1283-1284
  byte   HPSJU97 1285-1286
  byte   HPSJL97 1287-1288
  byte   HPSAU97 1289-1290
  byte   HPSSE97 1291-1292
  byte   HPSOC97 1293-1294
  byte   HPSNO97 1295-1296
  byte   HPSDE97 1297-1298
  byte   HPRJA97 1299-1300
  byte   HPRFE97 1301-1302
  byte   HPRMA97 1303-1304
  byte   HPRAP97 1305-1306
  byte   HPRMY97 1307-1308
  byte   HPRJU97 1309-1310
  byte   HPRJL97 1311-1312
  byte   HPRAU97 1313-1314
  byte   HPRSE97 1315-1316
  byte   HPROC97 1317-1318
  byte   HPRNO97 1319-1320
  byte   HPRDE97 1321-1322
  byte   INSJA97X 1323-1324
  byte   INSFE97X 1325-1326
  byte   INSMA97X 1327-1328
  byte   INSAP97X 1329-1330
  byte   INSMY97X 1331-1332
  byte   INSJU97X 1333-1334
  byte   INSJL97X 1335-1336
  byte   INSAU97X 1337-1338
  byte   INSSE97X 1339-1340
  byte   INSOC97X 1341-1342
  byte   INSNO97X 1343-1344
  byte   INSDE97X 1345-1346
  byte   PRVEV97 1347-1347
  byte   CHPEV97 1348-1348
  byte   MCDEV97 1349-1349
  byte   MCREV97 1350-1350
  byte   OPAEV97 1351-1351
  byte   OPBEV97 1352-1352
  byte   UNINS97 1353-1353
  byte   INSCOV97 1354-1354
  byte   RTHLTH31 1355-1356
  byte   RTHLTH42 1357-1358
  byte   RTHLTH53 1359-1360
  byte   RTPROX31 1361-1362
  byte   RTPROX42 1363-1364
  byte   RTPROX53 1365-1366
  byte   MNHLTH31 1367-1368
  byte   MNHLTH42 1369-1370
  byte   MNHLTH53 1371-1372
  byte   MNPROX31 1373-1374
  byte   MNPROX42 1375-1376
  byte   MNPROX53 1377-1378
  byte   IADLHP31 1379-1380
  byte   IADLHP42 1381-1382
  byte   IADLHP53 1383-1384
  byte   ADLHLP31 1385-1386
  byte   ADLHLP42 1387-1388
  byte   ADLHLP53 1389-1390
  byte   AIDHLP31 1391-1392
  byte   AIDHLP53 1393-1394
  byte   WLKLIM31 1395-1396
  byte   WLKLIM53 1397-1398
  byte   LFTDIF31 1399-1400
  byte   LFTDIF53 1401-1402
  byte   STPDIF31 1403-1404
  byte   STPDIF53 1405-1406
  byte   WLKDIF31 1407-1408
  byte   WLKDIF53 1409-1410
  byte   MILDIF31 1411-1412
  byte   MILDIF53 1413-1414
  byte   STNDIF31 1415-1416
  byte   STNDIF53 1417-1418
  byte   BENDIF31 1419-1420
  byte   BENDIF53 1421-1422
  byte   RCHDIF31 1423-1424
  byte   RCHDIF53 1425-1426
  byte   FNGRDF31 1427-1428
  byte   FNGRDF53 1429-1430
  byte   ACTLIM31 1431-1432
  byte   ACTLIM53 1433-1434
  byte   WRKLIM31 1435-1436
  byte   WRKLIM53 1437-1438
  byte   HSELIM31 1439-1440
  byte   HSELIM53 1441-1442
  byte   SCHLIM31 1443-1444
  byte   SCHLIM53 1445-1446
  byte   UNABLE31 1447-1448
  byte   UNABLE53 1449-1450
  byte   SOCLIM31 1451-1452
  byte   SOCLIM53 1453-1454
  byte   COGLIM31 1455-1456
  byte   COGLIM53 1457-1458
  byte   WRGLAS42 1459-1460
  byte   SEEDIF42 1461-1462
  byte   BLIND42 1463-1464
  byte   READNW42 1465-1466
  byte   RECPEP42 1467-1468
  byte   VISION42 1469-1470
  byte   HEARAD42 1471-1472
  byte   HEARDI42 1473-1474
  byte   DEAF42 1475-1476
  byte   HEARMO42 1477-1478
  byte   HEARSM42 1479-1480
  byte   HEARNG42 1481-1482
  byte   ANYLIM97 1483-1484
  byte   LIMACT42 1485-1486
  byte   PLYLIM42 1487-1488
  byte   CANTPL42 1489-1490
  byte   SPCPRO42 1491-1492
  byte   DPTSHT42 1493-1494
  byte   NUMDPT42 1495-1496
  byte   POLSHT42 1497-1498
  byte   NUMPOL42 1499-1500
  byte   MMRSHT42 1501-1502
  byte   HEPSHT42 1503-1504
  byte   MOMPRO42 1505-1506
  byte   DADPRO42 1507-1508
  byte   UNHAP42 1509-1510
  byte   SCHLBH42 1511-1512
  byte   HAVFUN42 1513-1514
  byte   ADUPRO42 1515-1516
  byte   NERVAF42 1517-1518
  byte   SIBPRO42 1519-1520
  byte   KIDPRO42 1521-1522
  byte   SPRPRO42 1523-1524
  byte   SCHPRO42 1525-1526
  byte   HOMEBH42 1527-1528
  byte   TRBLE42 1529-1530
  byte   SPCSCH42 1531-1532
  byte   SPECED42 1533-1534
  byte   SPCHTH42 1535-1536
  byte   PSYCNS42 1537-1538
  byte   OCUPTH42 1539-1540
  byte   VOCSVC42 1541-1542
  byte   TUTOR42 1543-1544
  byte   READIN42 1545-1546
  byte   PHYTHR42 1547-1548
  byte   LIFSKL42 1549-1550
  byte   FAMCNS42 1551-1552
  byte   RECTHR42 1553-1554
  byte   OTHSVC42 1555-1556
  byte   CANTSC42 1557-1558
  byte   LMOACT42 1559-1560
  byte   HLTHY42 1561-1562
  byte   NTHLTH42 1563-1564
  byte   GETSIC42 1565-1566
  byte   HGTFT42 1567-1568
  byte   HGTIN42 1569-1570
  int    WGTLB42 1571-1573
  byte   WGTOZ42 1574-1575
  byte   CHLIM42 1576-1577
  long   TOTTCH97 1578-1583
  long   TOTEXP97 1584-1589
  long   TOTSLF97 1590-1594
  long   TOTMCR97 1595-1600
  long   TOTMCD97 1601-1606
  long   TOTPRV97 1607-1612
  long   TOTVA97 1613-1618
  long   TOTCHM97 1619-1623
  long   TOTOFD97 1624-1628
  long   TOTSTL97 1629-1633
  long   TOTWCP97 1634-1638
  long   TOTOPR97 1639-1644
  long   TOTOPU97 1645-1649
  long   TOTOSR97 1650-1655
  int    OBTOTV97 1656-1658
  long   OBVTCH97 1659-1664
  long   OBVEXP97 1665-1669
  long   OBVSLF97 1670-1674
  long   OBVMCR97 1675-1679
  long   OBVMCD97 1680-1684
  long   OBVPRV97 1685-1689
  long   OBVVA97 1690-1694
  long   OBVCHM97 1695-1699
  int    OBVOFD97 1700-1703
  int    OBVSTL97 1704-1707
  int    OBVWCP97 1708-1711
  int    OBVOPR97 1712-1715
  int    OBVOPU97 1716-1719
  int    OBVOSR97 1720-1723
  int    OBDRV97 1724-1726
  long   OBDTCH97 1727-1731
  long   OBDEXP97 1732-1736
  long   OBDSLF97 1737-1741
  long   OBDMCR97 1742-1746
  long   OBDMCD97 1747-1751
  long   OBDPRV97 1752-1756
  long   OBDVA97 1757-1761
  long   OBDCHM97 1762-1766
  int    OBDOFD97 1767-1770
  int    OBDSTL97 1771-1774
  int    OBDWCP97 1775-1778
  int    OBDOPR97 1779-1782
  int    OBDOPU97 1783-1786
  int    OBDOSR97 1787-1790
  int    OBOTHV97 1791-1793
  long   OBOTCH97 1794-1799
  long   OBOEXP97 1800-1804
  long   OBOSLF97 1805-1809
  long   OBOMCR97 1810-1814
  long   OBOMCD97 1815-1819
  long   OBOPRV97 1820-1824
  int    OBOVA97 1825-1828
  int    OBOCHM97 1829-1832
  int    OBOOFD97 1833-1836
  int    OBOSTL97 1837-1840
  int    OBOWCP97 1841-1844
  int    OBOOPR97 1845-1848
  int    OBOOPU97 1849-1851
  int    OBOOSR97 1852-1855
  int    OBCHIR97 1856-1858
  long   OBCTCH97 1859-1863
  int    OBCEXP97 1864-1867
  int    OBCSLF97 1868-1871
  int    OBCMCR97 1872-1875
  int    OBCMCD97 1876-1878
  int    OBCPRV97 1879-1882
  byte   OBCVA97 1883-1884
  int    OBCCHM97 1885-1888
  byte   OBCOFD97 1889-1889
  byte   OBCSTL97 1890-1890
  int    OBCWCP97 1891-1894
  int    OBCOPR97 1895-1898
  int    OBCOPU97 1899-1901
  int    OBCOSR97 1902-1905
  int    OBNURS97 1906-1908
  long   OBNTCH97 1909-1914
  long   OBNEXP97 1915-1919
  int    OBNSLF97 1920-1923
  long   OBNMCR97 1924-1928
  long   OBNMCD97 1929-1933
  int    OBNPRV97 1934-1937
  int    OBNVA97 1938-1941
  int    OBNCHM97 1942-1944
  int    OBNOFD97 1945-1947
  int    OBNSTL97 1948-1950
  int    OBNWCP97 1951-1953
  int    OBNOPR97 1954-1957
  byte   OBNOPU97 1958-1959
  int    OBNOSR97 1960-1963
  byte   OBOPTO97 1964-1965
  int    OBETCH97 1966-1969
  int    OBEEXP97 1970-1973
  int    OBESLF97 1974-1976
  int    OBEMCR97 1977-1979
  int    OBEMCD97 1980-1982
  int    OBEPRV97 1983-1986
  byte   OBEVA97 1987-1988
  byte   OBECHM97 1989-1989
  int    OBEOFD97 1990-1992
  int    OBESTL97 1993-1995
  int    OBEWCP97 1996-1998
  int    OBEOPR97 1999-2002
  byte   OBEOPU97 2003-2004
  int    OBEOSR97 2005-2007
  byte   OBASST97 2008-2009
  long   OBATCH97 2010-2014
  int    OBAEXP97 2015-2018
  int    OBASLF97 2019-2022
  int    OBAMCR97 2023-2026
  int    OBAMCD97 2027-2030
  int    OBAPRV97 2031-2034
  byte   OBAVA97 2035-2036
  byte   OBACHM97 2037-2038
  int    OBAOFD97 2039-2041
  byte   OBASTL97 2042-2043
  int    OBAWCP97 2044-2047
  byte   OBAOPR97 2048-2049
  byte   OBAOPU97 2050-2051
  int    OBAOSR97 2052-2054
  byte   OBTHER97 2055-2056
  long   OBTTCH97 2057-2061
  long   OBTEXP97 2062-2066
  int    OBTSLF97 2067-2070
  int    OBTMCR97 2071-2074
  int    OBTMCD97 2075-2078
  long   OBTPRV97 2079-2083
  int    OBTVA97 2084-2087
  int    OBTCHM97 2088-2090
  int    OBTOFD97 2091-2094
  int    OBTSTL97 2095-2097
  int    OBTWCP97 2098-2101
  int    OBTOPR97 2102-2105
  byte   OBTOPU97 2106-2106
  int    OBTOSR97 2107-2110
  int    OPTOTV97 2111-2113
  long   OPFTCH97 2114-2119
  long   OPFEXP97 2120-2124
  long   OPFSLF97 2125-2129
  long   OPFMCR97 2130-2134
  long   OPFMCD97 2135-2139
  long   OPFPRV97 2140-2144
  long   OPFVA97 2145-2149
  long   OPFCHM97 2150-2154
  long   OPFOFD97 2155-2159
  int    OPFSTL97 2160-2163
  long   OPFWCP97 2164-2168
  int    OPFOPR97 2169-2172
  int    OPFOPU97 2173-2176
  long   OPFOSR97 2177-2181
  long   OPDEXP97 2182-2186
  long   OPDTCH97 2187-2191
  int    OPDSLF97 2192-2195
  long   OPDMCR97 2196-2200
  int    OPDMCD97 2201-2204
  int    OPDPRV97 2205-2208
  int    OPDVA97 2209-2211
  int    OPDCHM97 2212-2215
  int    OPDOFD97 2216-2218
  int    OPDSTL97 2219-2221
  int    OPDWCP97 2222-2225
  int    OPDOPR97 2226-2229
  int    OPDOPU97 2230-2233
  byte   OPDOSR97 2234-2234
  int    OPDRV97 2235-2237
  long   OPVTCH97 2238-2242
  long   OPVEXP97 2243-2247
  int    OPVSLF97 2248-2251
  long   OPVMCR97 2252-2256
  int    OPVMCD97 2257-2260
  long   OPVPRV97 2261-2265
  long   OPVVA97 2266-2270
  long   OPVCHM97 2271-2275
  long   OPVOFD97 2276-2280
  int    OPVSTL97 2281-2284
  long   OPVWCP97 2285-2289
  int    OPVOPR97 2290-2293
  int    OPVOPU97 2294-2297
  int    OPVOSR97 2298-2301
  long   OPSEXP97 2302-2306
  long   OPSTCH97 2307-2311
  int    OPSSLF97 2312-2315
  long   OPSMCR97 2316-2320
  int    OPSMCD97 2321-2324
  int    OPSPRV97 2325-2328
  int    OPSVA97 2329-2331
  int    OPSCHM97 2332-2335
  int    OPSOFD97 2336-2338
  int    OPSSTL97 2339-2341
  int    OPSWCP97 2342-2345
  int    OPSOPR97 2346-2349
  int    OPSOPU97 2350-2353
  byte   OPSOSR97 2354-2354
  int    OPOTHV97 2355-2357
  long   OPOTCH97 2358-2363
  long   OPOEXP97 2364-2368
  long   OPOSLF97 2369-2373
  long   OPOMCR97 2374-2378
  long   OPOMCD97 2379-2383
  long   OPOPRV97 2384-2388
  long   OPOVA97 2389-2393
  int    OPOCHM97 2394-2397
  int    OPOOFD97 2398-2401
  int    OPOSTL97 2402-2404
  long   OPOWCP97 2405-2409
  int    OPOOPR97 2410-2413
  int    OPOOPU97 2414-2416
  long   OPOOSR97 2417-2421
  long   OPPEXP97 2422-2426
  long   OPPTCH97 2427-2431
  int    OPPSLF97 2432-2435
  int    OPPMCR97 2436-2439
  int    OPPMCD97 2440-2443
  int    OPPPRV97 2444-2447
  int    OPPVA97 2448-2450
  byte   OPPCHM97 2451-2452
  int    OPPOFD97 2453-2455
  byte   OPPSTL97 2456-2457
  int    OPPWCP97 2458-2461
  int    OPPOPR97 2462-2465
  int    OPPOPU97 2466-2468
  byte   OPPOSR97 2469-2469
  int    AMCHIR97 2470-2472
  long   AMCTCH97 2473-2477
  int    AMCEXP97 2478-2481
  int    AMCSLF97 2482-2485
  int    AMCMCR97 2486-2489
  int    AMCMCD97 2490-2492
  int    AMCPRV97 2493-2496
  byte   AMCVA97 2497-2498
  int    AMCCHM97 2499-2502
  byte   AMCOFD97 2503-2503
  byte   AMCSTL97 2504-2504
  int    AMCWCP97 2505-2508
  int    AMCOPR97 2509-2512
  int    AMCOPU97 2513-2515
  int    AMCOSR97 2516-2519
  int    AMNURS97 2520-2522
  long   AMNTCH97 2523-2528
  long   AMNEXP97 2529-2533
  int    AMNSLF97 2534-2537
  long   AMNMCR97 2538-2542
  long   AMNMCD97 2543-2547
  long   AMNPRV97 2548-2552
  int    AMNVA97 2553-2556
  int    AMNCHM97 2557-2559
  int    AMNOFD97 2560-2562
  int    AMNSTL97 2563-2565
  int    AMNWCP97 2566-2569
  int    AMNOPR97 2570-2573
  byte   AMNOPU97 2574-2575
  int    AMNOSR97 2576-2579
  byte   AMOPTO97 2580-2581
  int    AMETCH97 2582-2585
  int    AMEEXP97 2586-2589
  int    AMESLF97 2590-2592
  int    AMEMCR97 2593-2596
  int    AMEMCD97 2597-2599
  int    AMEPRV97 2600-2603
  int    AMEVA97 2604-2606
  byte   AMECHM97 2607-2607
  int    AMEOFD97 2608-2610
  int    AMESTL97 2611-2613
  int    AMEWCP97 2614-2616
  int    AMEOPR97 2617-2620
  byte   AMEOPU97 2621-2622
  int    AMEOSR97 2623-2625
  byte   AMASST97 2626-2627
  long   AMATCH97 2628-2632
  int    AMAEXP97 2633-2636
  int    AMASLF97 2637-2640
  int    AMAMCR97 2641-2644
  int    AMAMCD97 2645-2648
  int    AMAPRV97 2649-2652
  byte   AMAVA97 2653-2654
  byte   AMACHM97 2655-2656
  int    AMAOFD97 2657-2659
  byte   AMASTL97 2660-2661
  int    AMAWCP97 2662-2665
  byte   AMAOPR97 2666-2667
  byte   AMAOPU97 2668-2669
  int    AMAOSR97 2670-2673
  int    AMTHER97 2674-2676
  long   AMTTCH97 2677-2681
  long   AMTEXP97 2682-2686
  int    AMTSLF97 2687-2690
  long   AMTMCR97 2691-2695
  int    AMTMCD97 2696-2699
  long   AMTPRV97 2700-2704
  long   AMTVA97 2705-2709
  int    AMTCHM97 2710-2712
  int    AMTOFD97 2713-2716
  int    AMTSTL97 2717-2719
  long   AMTWCP97 2720-2724
  long   AMTOPR97 2725-2729
  byte   AMTOPU97 2730-2731
  long   AMTOSR97 2732-2736
  int    AMTOTC97 2737-2739
  int    AMDRC97 2740-2742
  byte   ERTOT97 2743-2744
  long   ERFTCH97 2745-2749
  long   ERFEXP97 2750-2754
  long   ERFSLF97 2755-2759
  long   ERFMCR97 2760-2764
  long   ERFMCD97 2765-2769
  long   ERFPRV97 2770-2774
  long   ERFVA97 2775-2779
  int    ERFCHM97 2780-2783
  int    ERFOFD97 2784-2787
  int    ERFSTL97 2788-2790
  int    ERFWCP97 2791-2794
  int    ERFOPR97 2795-2798
  int    ERFOPU97 2799-2801
  long   ERFOSR97 2802-2806
  long   ERDEXP97 2807-2811
  long   ERDTCH97 2812-2816
  int    ERDSLF97 2817-2820
  int    ERDMCR97 2821-2824
  int    ERDMCD97 2825-2828
  int    ERDPRV97 2829-2832
  byte   ERDVA97 2833-2834
  int    ERDCHM97 2835-2837
  int    ERDOFD97 2838-2840
  byte   ERDSTL97 2841-2842
  int    ERDWCP97 2843-2846
  long   ERDOPR97 2847-2851
  int    ERDOPU97 2852-2854
  int    ERDOSR97 2855-2857
  byte   IPZERO97 2858-2858
  long   ZIFTCH97 2859-2863
  long   ZIFEXP97 2864-2868
  int    ZIFSLF97 2869-2872
  long   ZIFMCR97 2873-2877
  int    ZIFMCD97 2878-2881
  int    ZIFPRV97 2882-2885
  int    ZIFVA97 2886-2889
  int    ZIFCHM97 2890-2892
  int    ZIFOFD97 2893-2896
  byte   ZIFSTL97 2897-2897
  long   ZIFWCP97 2898-2902
  int    ZIFOPR97 2903-2906
  int    ZIFOPU97 2907-2909
  int    ZIFOSR97 2910-2913
  int    ZIDEXP97 2914-2917
  long   ZIDTCH97 2918-2922
  int    ZIDSLF97 2923-2925
  int    ZIDMCR97 2926-2929
  int    ZIDMCD97 2930-2932
  int    ZIDPRV97 2933-2936
  byte   ZIDVA97 2937-2937
  byte   ZIDCHM97 2938-2938
  byte   ZIDOFD97 2939-2939
  byte   ZIDSTL97 2940-2940
  int    ZIDWCP97 2941-2944
  int    ZIDOPR97 2945-2948
  int    ZIDOPU97 2949-2951
  byte   ZIDOSR97 2952-2952
  byte   IPDIS97 2953-2953
  long   IPFEXP97 2954-2959
  long   IPFTCH97 2960-2965
  long   IPFSLF97 2966-2970
  long   IPFMCR97 2971-2976
  long   IPFMCD97 2977-2982
  long   IPFPRV97 2983-2988
  long   IPFVA97 2989-2994
  long   IPFCHM97 2995-2999
  long   IPFOFD97 3000-3004
  int    IPFSTL97 3005-3008
  long   IPFWCP97 3009-3013
  long   IPFOPR97 3014-3019
  long   IPFOPU97 3020-3024
  long   IPFOSR97 3025-3030
  long   IPDEXP97 3031-3035
  long   IPDTCH97 3036-3040
  int    IPDSLF97 3041-3044
  long   IPDMCR97 3045-3049
  int    IPDMCD97 3050-3053
  long   IPDPRV97 3054-3058
  int    IPDVA97 3059-3061
  int    IPDCHM97 3062-3065
  int    IPDOFD97 3066-3068
  int    IPDSTL97 3069-3071
  int    IPDWCP97 3072-3075
  long   IPDOPR97 3076-3080
  int    IPDOPU97 3081-3084
  int    IPDOSR97 3085-3087
  int    IPNGTD97 3088-3090
  byte   DVTOT97 3091-3092
  long   DVTTCH97 3093-3097
  long   DVTEXP97 3098-3102
  long   DVTSLF97 3103-3107
  int    DVTMCR97 3108-3111
  int    DVTMCD97 3112-3115
  long   DVTPRV97 3116-3120
  int    DVTVA97 3121-3124
  int    DVTCHM97 3125-3128
  int    DVTOFD97 3129-3132
  int    DVTSTL97 3133-3136
  int    DVTWCP97 3137-3140
  long   DVTOPR97 3141-3145
  int    DVTOPU97 3146-3149
  int    DVTOSR97 3150-3153
  byte   DVGEN97 3154-3155
  long   DVGTCH97 3156-3160
  long   DVGEXP97 3161-3165
  long   DVGSLF97 3166-3170
  int    DVGMCR97 3171-3174
  int    DVGMCD97 3175-3178
  int    DVGPRV97 3179-3182
  int    DVGVA97 3183-3186
  int    DVGCHM97 3187-3190
  int    DVGOFD97 3191-3193
  int    DVGSTL97 3194-3197
  int    DVGWCP97 3198-3201
  int    DVGOPR97 3202-3205
  int    DVGOPU97 3206-3209
  int    DVGOSR97 3210-3213
  byte   DVORTH97 3214-3215
  long   DVOTCH97 3216-3220
  long   DVOEXP97 3221-3225
  int    DVOSLF97 3226-3229
  byte   DVOMCR97 3230-3230
  int    DVOMCD97 3231-3234
  long   DVOPRV97 3235-3239
  byte   DVOVA97 3240-3241
  int    DVOCHM97 3242-3244
  int    DVOOFD97 3245-3248
  int    DVOSTL97 3249-3251
  int    DVOWCP97 3252-3254
  long   DVOOPR97 3255-3259
  byte   DVOOPU97 3260-3260
  int    DVOOSR97 3261-3264
  int    HHTOTD97 3265-3267
  int    HHAGD97 3268-3270
  long   HHATCH97 3271-3276
  long   HHAEXP97 3277-3281
  long   HHASLF97 3282-3286
  long   HHAMCR97 3287-3291
  long   HHAMCD97 3292-3296
  long   HHAPRV97 3297-3301
  byte   HHAVA97 3302-3303
  byte   HHACHM97 3304-3304
  int    HHAOFD97 3305-3308
  long   HHASTL97 3309-3313
  int    HHAWCP97 3314-3316
  long   HHAOPR97 3317-3321
  int    HHAOPU97 3322-3325
  byte   HHAOSR97 3326-3326
  int    HHINDD97 3327-3329
  long   HHNTCH97 3330-3334
  long   HHNEXP97 3335-3339
  long   HHNSLF97 3340-3344
  long   HHNMCR97 3345-3349
  long   HHNMCD97 3350-3354
  long   HHNPRV97 3355-3359
  byte   HHNVA97 3360-3360
  byte   HHNCHM97 3361-3361
  byte   HHNOFD97 3362-3362
  int    HHNSTL97 3363-3365
  byte   HHNWCP97 3366-3367
  int    HHNOPR97 3368-3371
  byte   HHNOPU97 3372-3372
  int    HHNOSR97 3373-3376
  int    HHINFD97 3377-3379
  int    VISEXP97 3380-3383
  int    VISTCH97 3384-3387
  int    VISSLF97 3388-3391
  int    VISMCR97 3392-3394
  int    VISMCD97 3395-3397
  int    VISPRV97 3398-3401
  int    VISVA97 3402-3404
  int    VISCHM97 3405-3407
  int    VISOFD97 3408-3410
  int    VISSTL97 3411-3413
  int    VISWCP97 3414-3416
  int    VISOPR97 3417-3419
  int    VISOPU97 3420-3422
  int    VISOSR97 3423-3425
  long   OTHTCH97 3426-3430
  long   OTHEXP97 3431-3435
  long   OTHSLF97 3436-3440
  int    OTHMCR97 3441-3444
  int    OTHMCD97 3445-3448
  long   OTHPRV97 3449-3453
  long   OTHVA97 3454-3458
  int    OTHCHM97 3459-3461
  int    OTHOFD97 3462-3464
  int    OTHSTL97 3465-3468
  int    OTHWCP97 3469-3472
  int    OTHOPR97 3473-3476
  int    OTHOPU97 3477-3479
  long   OTHOSR97 3480-3484
  int    RXTOT97 3485-3487
  long   RXEXP97 3488-3492
  long   RXSLF97 3493-3497
  int    RXMCR97 3498-3501
  long   RXMCD97 3502-3506
  long   RXPRV97 3507-3511
  int    RXVA97 3512-3515
  int    RXCHM97 3516-3519
  int    RXOFD97 3520-3523
  int    RXSTL97 3524-3527
  int    RXWCP97 3528-3531
  int    RXOPR97 3532-3535
  int    RXOPU97 3536-3539
  int    RXOSR97 3540-3543
  double WTDPER97 3544-3555
  double WTFAMF97 3556-3567
  double WTCFAM97 3568-3579
  int    VARSTR97 3580-3582
  byte   VARPSU97 3583-3584
using H20.dat;

*DEFINE VARIABLE LABELS;
label variable DUID "DWELLING UNIT ID";
label variable PID "PERSON ID";
label variable DUPERSID "PERSON ID (DUID + PID)";
label variable PANEL97 "PANEL NUMBER";
label variable FAMID31 "FAMILY ID (STUDENT MERGED IN) - RD3/1";
label variable FAMID42 "FAMILY ID (STUDENT MERGED IN) - RD4/2";
label variable FAMID53 "FAMILY ID (STUDENT MERGED IN) - RD5/3";
label variable FAMID97 "FAMILY ID (STUDENT MERGED IN)-12/31/97";
label variable FAMIDYR "ANNUAL FAMILY IDENTIFIER";
label variable CPSFAMID "CPS-LIKE FAMILY IDENTIFIER";
label variable FCSZ1231 "FAM SIZE RESPONDING 12/31 CPS FAMILY";
label variable FCRP1231 "REF PERSON OF 12/31 CPS FAMILY";
label variable RULETR31 "RU LETTER - R3/1";
label variable RULETR42 "RU LETTER - R4/2";
label variable RULETR53 "RU LETTER - R5/3";
label variable RULETR97 "RU LETTER AS OF 12/31/97";
label variable RUSIZE31 "RU SIZE - R3/1";
label variable RUSIZE42 "RU SIZE - R4/2";
label variable RUSIZE53 "RU SIZE - R5/3";
label variable RUSIZE97 "RU SIZE AS OF 12/31/97";
label variable RUCLAS31 "RU FIELDED AS:STANDARD,NEW,STUDENT-R3/1";
label variable RUCLAS42 "RU FIELDED AS:STANDARD,NEW,STUDENT-R4/2";
label variable RUCLAS53 "RU FIELDED AS: STANDARD,NEW,STUDENT-R5/3";
label variable RUCLAS97 "RU FIELDED AS:STANDARD,NEW,STUD-12/31/97";
label variable FAMSZE31 "RU SIZE INCLUDING STUDENTS - R3/1";
label variable FAMSZE42 "RU SIZE INCLUDING STUDENTS - R4/2";
label variable FAMSZE53 "RU SIZE INCLUDING STUDENTS - R5/3";
label variable FAMSZE97 "RU SIZE INCLUDING STUDENT AS OF 12/31/97";
label variable FMRS1231 "MEMBER OF RESPONDING 12/31 FAMILY";
label variable FAMS1231 "FAMILY SIZE OF RESPONDING 12/31 FAMILY";
label variable FAMSZEYR "SIZE OF RESPONDING ANNUALIZED FAMILY";
label variable FAMRFPYR "REFERENCE PERSON OF ANNUALIZED FAMILY";
label variable FYFAMTYP "CPS - FULL YEAR FAMILY TYPE";
label variable INRU1231 "PERSON WAS IN RU ON 12/31/97";
label variable REGION31 "CENSUS REGION - R3/1";
label variable REGION42 "CENSUS REGION - R4/2";
label variable REGION53 "CENSUS REGION - R5/3";
label variable REGION97 "CENSUS REGION AS OF 12/31/97";
label variable MSA53 "MSA R5/3 STATUS";
label variable MSA97 "MSA AS OF 12/31/97";
label variable REFPRS31 "REFERENCE PERSON - R3/1";
label variable REFPRS42 "REFERENCE PERSON AT - R4/2";
label variable REFPRS53 "REFERENCE PERSON AT - R5/3";
label variable REFPRS97 "REFERENCE PERSON AS OF 12/31/97";
label variable RESP31 "1ST RESPONDENT INDICATOR FOR R3/1";
label variable RESP42 "1ST RESPONDENT INDICATOR FOR R4/2";
label variable RESP53 "1ST RESPONDENT INDICATOR FOR R5/3";
label variable RESP97 "1ST RESPONDENT INDICATOR AS OF 12/31/97";
label variable PROXY31 "WAS RESPONDENT A PROXY IN R3/1";
label variable PROXY42 "WAS RESPONDENT A PROXY IN R4/2";
label variable PROXY53 "WAS RESPONDENT A PROXY IN R5/3";
label variable PROXY97 "WAS RESPONDENT A PROXY AS OF 12/31/97";
label variable BEGRFD31 "R3/1 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM31 "R3/1 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY31 "R3/1 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD31 "R3/1 REF PERIOD END DATE: DAY";
label variable ENDRFM31 "R3/1 REF PERIOD END DATE: MONTH";
label variable ENDRFY31 "R3/1 REF PERIOD END DATE: YEAR";
label variable BEGRFD42 "R4/2 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM42 "R4/2 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY42 "R4/2 REFERENCE PERIOD BEGIN DATE: YEAR";
label variable ENDRFD42 "R4/2 REF PERIOD END DATE: DAY";
label variable ENDRFM42 "R4/2 REF PERIOD END DATE: MONTH";
label variable ENDRFY42 "R4/2 REF PERIOD END DATE: YEAR";
label variable BEGRFD53 "R5/3 REFERENCE PERIOD BEGIN DATE: DAY";
label variable BEGRFM53 "R5/3 REFERENCE PERIOD BEGIN DATE: MONTH";
label variable BEGRFY53 "R5/3 REFERENCE PERIOD BEGINDATE: YEAR";
label variable ENDRFD53 "R5/3 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM53 "R5/3 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY53 "R5/3 REFERENCE PERIOD END DATE: YEAR";
label variable ENDRFD97 "1997 REFERENCE PERIOD END DATE: DAY";
label variable ENDRFM97 "1997 REFERENCE PERIOD END DATE: MONTH";
label variable ENDRFY97 "1997 REFERENCE PERIOD END DATE: YEAR";
label variable KEYNESS "PERSON KEY STATUS";
label variable INSCOP31 "INSCOPE - R3/1";
label variable INSCOP42 "INSCOPE - R4/2";
label variable INSCOP53 "INSCOPE - R5/3";
label variable INSCOP97 "INSCOPE - R5/R3 START THROUGH 12/31/97";
label variable INSC1231 "IN-SCOPE STATUS ON DECEMBER 31, 1997";
label variable INSCOPE "WAS PERSON EVER INSCOPE IN 1997";
label variable ELGRND31 "ELIGIBILITY - R3/1";
label variable ELGRND42 "ELIGIBILITY - R4/2";
label variable ELGRND53 "ELIGIBILITY: ELIGIBLE/NOT ELIGIBLE -R5/3";
label variable ELGRND97 "ELIGIBILITY-R5/R3 START THROUGH 12/31/97";
label variable ELIGIBLE "WAS PERSON EVER ELIGIBLE IN 1997";
label variable PSTATS31 "PERSON DISPOSITION STATUS - R3/1";
label variable PSTATS42 "PERSON DISPOSITION STATUS - R4/2";
label variable PSTATS53 "PERSON DISPOSITION STATUS - R5/3";
label variable RURSLT31 "RU RESULT - R3/1";
label variable RURSLT42 "RU RESULT - R4/2";
label variable RURSLT53 "RU RESULT - R5/3";
label variable AGE31X "AGE-R3/1 (EDITED/IMPUTED)";
label variable AGE42X "AGE-R4/2 (EDITED/IMPUTED)";
label variable AGE53X "AGE - R5/3 (EDITED/IMPUTED)";
label variable AGE97X "AGE AS OF 12/31/97 (EDITED/IMPUTED)";
label variable DOBMM "DATE OF BIRTH: MONTH";
label variable DOBYY "DATE OF BIRTH: YEAR";
label variable SEX "SEX";
label variable RACEX "RACE (EDITED/IMPUTED)";
label variable RACETHNX "RACE/ETHNICITY (EDITED/IMPUTED)";
label variable HISPANX "HISPANIC ETHNICITY (EDITED/IMPUTED)";
label variable HISPCAT "SPECIFIC HISPANIC ETHNICITY GROUP";
label variable MARRY31X "MARITAL STATUS - R3/1 (EDITED/IMPUTED)";
label variable MARRY42X "MARITAL STATUS - R4/2 (EDITED/IMPUTED)";
label variable MARRY53X "MARITAL STATUS - R5/3 (EDITED/IMPUTED)";
label variable MARRY97X "MARITAL STATUS-12/31/97 (EDITED/IMPUTED)";
label variable SPOUID31 "SPOUSE ID - R3/1";
label variable SPOUID42 "SPOUSE ID - R4/2";
label variable SPOUID53 "SPOUSE ID - R5/3";
label variable SPOUID97 "SPOUSE ID-12/31/97";
label variable SPOUIN31 "MARITAL STATUS W/ SPOUSE PRESENT R3/1";
label variable SPOUIN42 "MARITAL STATUS W/ SPOUSE PRESENT R4/2";
label variable SPOUIN53 "MARITAL STATUS W/SPOUSE PRESENT R5/3";
label variable SPOUIN97 "MARITAL STATUS W/SPOUSE PRESENT-12/31/97";
label variable EDUCYR31 "COMPLETED YEARS OF EDUCATION - R3/1";
label variable EDUCYR42 "COMPLETED YEARS OF EDUCATION - R4/2";
label variable EDUCYR53 "COMPLETED YEARS OF EDUCATION - R5/3";
label variable EDUCYR97 "COMPLETED YEARS OF EDUCATION - 12/31/97";
label variable HIDEG31 "HIGHEST DEGREE EARNED R3/1";
label variable HIDEG42 "HIGHEST DEGREE EARNED R4/2";
label variable HIDEG53 "HIGHEST DEGREE EARNED R5/3";
label variable HIDEG97 "HIGHEST DEGREE-12/31/97";
label variable FTSTU31X "STUDENT STATUS IF AGES 17-23 R3/1";
label variable FTSTU42X "STUDENT STATUS IF AGES 17-23 R4/2";
label variable FTSTU53X "STUDENT STATUS IF AGES 17-23R5/3";
label variable FTSTU97X "STUDENT STATUS IF AGES 17-23 - 12/31/97";
label variable ACTDTY31 "MILITARY FULL-TIME ACTIVE DUTY - RD 3/1";
label variable ACTDTY42 "MILITARY FULL-TIME ACTIVE DUTY - RD 4/2";
label variable ACTDTY53 "MILITARY FULL-TIME ACTIVE DUTY - RD 5/3";
label variable DIDSERVE "EVER SERVED IN ARMED FORCES";
label variable VETPVIET "SERVED IN POST-VIETNAM ERA";
label variable VETVIET "SERVED IN VIETNAM WAR ERA";
label variable VETKOR "SERVED IN KOREAN WAR ERA";
label variable VETWW "SERVED IN WWI OR WW2 ERA";
label variable VETOTH "SERVED IN OTHER PERIOD";
label variable RFREL31X "RELATION TO REF PERS R3/1 (EDIT/IMP)";
label variable RFREL42X "RELATION TO REF PERS R4/2 (EDIT/IMP)";
label variable RFREL53X "RELATION TO REF PERS R5/3 (EDIT/IMP)";
label variable RFREL97X "RELATION TO REF PERS 12/31/97 (EDIT/IMP)";
label variable MOPID31X "PID OF PERSON S MOM - RD 3/1";
label variable MOPID42X "PID OF PERSON S MOM - RD 4/2";
label variable MOPID53X "PID OF PERSON S MOM - RD 5/3";
label variable DAPID31X "PID OF PERSON S DAD - RD 3/1";
label variable DAPID42X "PID OF PERSON S DAD - RD 4/2";
label variable DAPID53X "PID OF PERSON S DAD - RD 5/3";
label variable SSIDIS97 "SSI INCOME DUE TO DISABILITY";
label variable AFDC97 "ANY AFDC OR ADC INCOME";
label variable FILEDR97 "HAS PERSON FILED A FED INCOME TAX RETURN";
label variable WILFIL97 "WILL PERSON FILE FED INCOME TAX RETURN";
label variable FLSTAT97 "PERSON S FILING STATUS";
label variable FILER97 "PRIMARY OR SECONDARY FILER";
label variable JTINRU97 "JOINT FILER S MEMBERSHIP IN RU";
label variable JNTPID97 "PID OF SECONDARY FILER";
label variable CLMDEP97 "DID/WILL PERS CLAIM DEPENDENTS ON RETURN";
label variable DEPDNT97 "PERSON IS FLAGGED A DEPENDENT";
label variable DPINRU97 "DEPENDENTS IN/OUT OF RU";
label variable DPOTSD97 "HOW MANY DEPENDENTS LIVE OUTSIDE RU";
label variable TAXFRM97 "TAX FORM PERSON WILL FILE";
label variable DEDUCT97 "ITEMIZE OR STANDARD DEDUCTION";
label variable ITMEXP97 "WILL PERSON ITEMIZE MEDICAL EXPENSE";
label variable MEXAMT97 "TOTAL AMOUNT FOR MEDICAL EXPENSES";
label variable NTMDED97 "PERSON S NET MEDICAL EXPENSE DEDUCTION";
label variable TOTDED97 "TOTAL OF ALL ITEMIZED DEDUCTIONS";
label variable CLMHIP97 "DID/WILL PERS DEDUCT HLTH INSUR PREM";
label variable ELDISC97 "DID/WILL PERS RECEIVE ELDERLY/DISAB CRED";
label variable EICRDT97 "DID/WILL PERS RECEIVE EARNED INC CREDIT";
label variable UNEMTX97 "TAXABLE PERCENTAGE OF UNEMPLOYMENT";
label variable INTRTX97 "TAXABLE PERCENTAGE OF INTEREST";
label variable SSECTX97 "TAXABLE PERCENTAGE OF SOCIAL SECURITY";
label variable IRATAX97 "TAXABLE PERCENTAGE OF IRA INCOME";
label variable FOODST97 "DID ANYONE PURCHASE FOOD STAMPS";
label variable FOODMN97 "HOW MANY MONTHS FOOD STAMPS PURCHASED";
label variable FOODCT97 "AMOUNT FAMILY PAID FOR FOOD STAMPS";
label variable FOODVL97 "MONTHLY VALUE OF FOOD STAMPS";
label variable TTLP97X "PERSON S TOTAL INCOME";
label variable POVCAT97 "FAMILY INCOME AS PERCENT OF POVERTY LINE";
label variable WAGEP97X "PERSON S WAGE INCOME";
label variable WAGIMP97 "WAGE IMPUTATION FLAG";
label variable BUSNP97X "PERSON S BUSINESS INCOME";
label variable BUSIMP97 "BUSINESS INCOME IMPUTATION FLAG";
label variable FARMP97X "PERSON S FARM INCOME";
label variable FARIMP97 "FARM INCOME IMPUTATION FLAG";
label variable UNEMP97X "PERSON S UNEMPLOYMENT COMP";
label variable UNEIMP97 "UNEMPLOYMENT IMPUTATION FLAG";
label variable WCMPP97X "PERSON S WORKMANS COMPENSATION";
label variable WCPIMP97 "WORKMANS COMP IMPUTATION FLAG";
label variable INTRP97X "PERSON S INTEREST INCOME";
label variable INTIMP97 "INTEREST INCOME IMPUTATION FLAG";
label variable DIVDP97X "PERSON S DIVIDEND INCOME";
label variable DIVIMP97 "DIVIDEND INCOME IMPUTATION FLAG";
label variable SALEP97X "PERSON S SALES INCOME";
label variable SALIMP97 "SALES INCOME IMPUTATION FLAG";
label variable PENSP97X "PERSON S PENSION INCOME";
label variable PENIMP97 "PENSION INCOME IMPUTATION FLAG";
label variable SSECP97X "PERSON S SOCIAL SECURITY INCOME";
label variable SSCIMP97 "SOCIAL SECURITY INCOME IMPUTATION FLAG";
label variable TRSTP97X "PERSON S TRUST/RENT INCOME";
label variable TRTIMP97 "TRUST INCOME IMPUTATION FLAG";
label variable VETSP97X "PERSON S VETERANS INCOME";
label variable VETIMP97 "VETERANS INCOME IMPUTATION FLAG";
label variable IRASP97X "PERSON S IRA INCOME";
label variable IRAIMP97 "IRA INCOME IMPUTATION FLAG";
label variable REFDP97X "PERSON S REFUND INCOME";
label variable REFIMP97 "REFUND INCOME IMPUTATION FLAG";
label variable ALIMP97X "PERSON S ALIMONY INCOME";
label variable ALIIMP97 "ALIMONY INCOME IMPUTATION FLAG";
label variable CHLDP97X "CHILD SUPPORT INCOME";
label variable CHLIMP97 "CHILD SUPPORT IMPUTATION FLAG";
label variable CASHP97X "PERSON S OTHER REGULAR CASH CONTRIB";
label variable CSHIMP97 "CASH CONTRIBUTION IMPUTATION FLAG";
label variable SSIP97X "SSI INCOME";
label variable SSIIMP97 "SSI IMPUTATION FLAG";
label variable PUBP97X "PUBLIC ASSISTANCE INCOME";
label variable PUBIMP97 "PUBLIC ASSISTANCE IMPUTATION FLAG";
label variable OTHRP97X "OTHER INCOME";
label variable OTHIMP97 "OTHER INCOME IMPUTATION FLAG";
label variable EMPST31 "EMPLOYMENT STATUS RD 3/1";
label variable EMPST42 "EMPLOYMENT STATUS RD 4/2";
label variable EMPST53 "EMPLOYMENT STATUS RD 5/3";
label variable RNDFLG31 "DATA COLLECTION ROUND FOR RD 3/1 CMJ";
label variable MORJOB31 "HAS MORE THAN ONE JOB RD 3/1 INT DATE";
label variable MORJOB42 "HAS MORE THAN ONE JOB RD 4/2 INT DATE";
label variable MORJOB53 "HAS MORE THAN ONE JOB RD 5/3 INT DATE";
label variable EVRWRK "EVER WRKD FOR PAY IN LIFE AS OF 12/31/97";
label variable HRWG31X "HOURLY WAGE RD 3/1 CMJ";
label variable HRWG42X "HOURLY WAGE RD 4/2 CMJ";
label variable HRWG53X "HOURLY WAGE RD 5/3 CMJ";
label variable HRWGIM31 "HRWG31X IMPUTATION FLAG";
label variable HRWGIM42 "HRWG42X IMPUTATION FLAG";
label variable HRWGIM53 "HRWG53X IMPUTATION FLAG";
label variable HRHOW31 "HOW HOURLY WAGE WAS CALCULATED R3/1";
label variable HRHOW42 "HOW HOURLY WAGE WAS CALCULATED R4/2";
label variable HRHOW53 "HOW HOURLY WAGE WAS CALCULATED R5/3";
label variable HOUR31 "HOURS PER WEEK AT RD 3/1 CMJ";
label variable HOUR42 "HOURS PER WEEK AT RD 4/2 CMJ";
label variable HOUR53 "HOURS PER WEEK AT RD 5/3 CMJ";
label variable SELFCM31 "SELF-EMPLOYED AT RD 3/1 CMJ";
label variable SELFCM42 "SELF-EMPLOYED AT RD 4/2 CMJ";
label variable SELFCM53 "SELF-EMPLOYED AT RD 5/3 CMJ";
label variable DISVW31X "DISAVOWED HEALTH INS AT R3/1 CMJ";
label variable DISVW42X "DISAVOWED HEALTH INS AT R4/2 CMJ";
label variable DISVW53X "DISAVOWED HEALTH INS AT R5/3 CMJ";
label variable CHOIC31 "CHOICE OF HEALTH PLANS AT RD 3/1 CMJ";
label variable CHOIC42 "CHOICE OF HEALTH PLANS AT RD 4/2 CMJ";
label variable CHOIC53 "CHOICE OF HEALTH PLANS AT RD 5/3 CMJ";
label variable CIND31 "CONDENSED INDUSTRY CODE RD 3/1 CMJ";
label variable CIND42 "CONDENSED INDUSTRY CODE RD 4/2 CMJ";
label variable CIND53 "CONDENSED INDUSTRY CODE RD 5/3 CMJ";
label variable NUMEMP31 "NUMBER OF EMPLOYEES AT RD 3/1 CMJ";
label variable NUMEMP42 "NUMBER OF EMPLOYEES AT RD 4/2 CMJ";
label variable NUMEMP53 "NUMBER OF EMPLOYEES AT RD 5/3 CMJ";
label variable MORE31 "RD 3/1 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE42 "RD 4/2 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable MORE53 "RD 5/3 CMJ FIRM HAS MORE THAN 1 LOCAT";
label variable UNION31 "UNION STATUS AT RD 3/1 CMJ";
label variable UNION42 "UNION STATUS AT RD 4/2 CMJ";
label variable UNION53 "UNION STATUS AT RD 5/3 CMJ";
label variable NWK31 "REASON NOT WORKING DURING RD 3/1";
label variable NWK42 "REASON NOT WORKING DURING RD 4/2";
label variable NWK53 "REASON NOT WORKING DURING RD 5/3";
label variable CHGJ3142 "CHANGED JOB BETWEEN RD 3/1 AND RD 4/2";
label variable CHGJ4253 "CHANGED JOB BETWEEN RD 4/2 AND RD 5/3";
label variable YCHJ3142 "WHY CHNGD JOB BETWEEN RD 3/1 AND RD 4/2";
label variable YCHJ4253 "WHY CHNGD JOB BETWEEN RD 4/2 AND RD 5/3";
label variable STJBMM31 "MONTH STARTED RD 3/1 CMJ";
label variable STJBDD31 "DAY STARTED RD 3/1 CMJ";
label variable STJBYY31 "YEAR STARTED RD 3/1 CMJ";
label variable STJBMM42 "MONTH STARTED RD 4/2 CMJ";
label variable STJBDD42 "DAY STARTED RD 4/2 CMJ";
label variable STJBYY42 "YEAR STARTED RD 4/2 CMJ";
label variable STJBMM53 "MONTH STARTED RD 5/3 CMJ";
label variable STJBDD53 "DAY STARTED RD 5/3 CMJ";
label variable STJBYY53 "YEAR STARTED RD 5/3 CMJ";
label variable EVRETIRE "PERSON HAS EVER RETIRED";
label variable COCCP31 "CONDENSED OCCUPATION CODE RD 3/1 CMJ";
label variable COCCP42 "CONDENSED OCCUPATION CODE RD 4/2 CMJ";
label variable COCCP53 "CONDENSED OCCUPATION CODES RD 5/3 CMJ";
label variable BGNWK31 "USUAL START TIME OF RD 3/1 CMJ";
label variable BGNWK42 "USUAL START TIME OF RD 4/2 CMJ";
label variable BGNWK53 "USUAL START TIME OF RD 5/3 CMJ";
label variable ENDWK31 "USUAL END TIME OF RD 3/1 CMJ";
label variable ENDWK42 "USUAL END TIME OF RD 4/2 CMJ";
label variable ENDWK53 "USUAL END TIME OF RD 5/3 CMJ";
label variable PAYVAC31 "PAID VACATION AT RD 3/1 CMJ";
label variable PAYVAC42 "PAID VACATION AT RD 4/2 CMJ";
label variable PAYVAC53 "PAID VACATION AT RD 5/3 CMJ";
label variable SICPAY31 "PAID SICK LEAVE AT RD 3/1 CMJ";
label variable SICPAY42 "PAID SICK LEAVE AT RD 4/2 CMJ";
label variable SICPAY53 "PAID SICK LEAVE AT RD 5/3 CMJ";
label variable PAYDR31 "PAID LEAVE TO VISIT DR RD 3/1 CMJ";
label variable PAYDR42 "PAID LEAVE TO VISIT DR RD 4/2 CMJ";
label variable PAYDR53 "PAID LEAVE TO VISIT DR RD 5/3 CMJ";
label variable RETPLN31 "PENSION PLAN AT RD 3/1 CMJ";
label variable RETPLN42 "PENSION PLAN AT RD 4/2 CMJ";
label variable RETPLN53 "PENSION PLAN AT RD 5/3 CMJ";
label variable SHFTWK31 "IRREGULAR WORK SHIFT RD 3/1 CMJ";
label variable SHFTWK42 "IRREGULAR WORK SHIFT RD 4/2 CMJ";
label variable SHFTWK53 "IRREGULAR WORK SHIFT RD 5/3 CMJ";
label variable BSNTY31 "SOLE PROP, PARTNER, CORP, RD 3/1 CMJ";
label variable BSNTY42 "SOLE PROP, PARTNER, CORP, RD 4/2 CMJ";
label variable BSNTY53 "SOLE PROP, PARTNER, CORP, RD 5/3 CMJ";
label variable JOBORG31 "PRIV (PROFIT,NONPROFIT) GOV RD 3/1 CMJ";
label variable JOBORG42 "PRIV (PROFIT,NONPROFIT) GOV RD 4/2 CMJ";
label variable JOBORG53 "PRIV (PROFIT,NONPROFIT) GOV RD 5/3 CMJ";
label variable HELD31X "HEALTH INSURANCE HELD FROM RD 3/1 CMJ";
label variable HELD42X "HEALTH INSURANCE HELD FROM RD 4/2 CMJ";
label variable HELD53X "HEALTH INSURANCE HELD FROM RD 5/3 CMJ";
label variable OFFER31X "HEALTH INSURANCE OFFERED BY RD 3/1 CMJ";
label variable OFFER42X "HEALTH INSURANCE OFFERED BY RD 4/2 CMJ";
label variable OFFER53X "HEALTH INSURANCE OFFERED BY RD 5/3 CMJ";
label variable CHJA97X "COVERED BY CHAMPUS/CHAMPVA IN JAN97 (ED)";
label variable CHFE97X "COVERED BY CHAMPUS/CHAMPVA IN FEB97 (ED)";
label variable CHMA97X "COVERED BY CHAMPUS/CHAMPVA IN MAR97 (ED)";
label variable CHAP97X "COVERED BY CHAMPUS/CHAMPVA IN APR97 (ED)";
label variable CHMY97X "COVERED BY CHAMPUS/CHAMPVA IN MAY97 (ED)";
label variable CHJU97X "COVERED BY CHAMPUS/CHAMPVA IN JUN97 (ED)";
label variable CHJL97X "COVERED BY CHAMPUS/CHAMPVA IN JUL97 (ED)";
label variable CHAU97X "COVERED BY CHAMPUS/CHAMPVA IN AUG97 (ED)";
label variable CHSE97X "COVERED BY CHAMPUS/CHAMPVA IN SEP97 (ED)";
label variable CHOC97X "COVERED BY CHAMPUS/CHAMPVA IN OCT97 (ED)";
label variable CHNO97X "COVERED BY CHAMPUS/CHAMPVA IN NOV97 (ED)";
label variable CHDE97X "COVERED BY CHAMPUS/CHAMPVA IN DEC97 (ED)";
label variable MCRJA97 "COVERED BY MEDICARE IN JAN97";
label variable MCRFE97 "COVERED BY MEDICARE IN FEB97";
label variable MCRMA97 "COVERED BY MEDICARE IN MAR97";
label variable MCRAP97 "COVERED BY MEDICARE IN APR97";
label variable MCRMY97 "COVERED BY MEDICARE IN MAY97";
label variable MCRJU97 "COVERED BY MEDICARE IN JUN97";
label variable MCRJL97 "COVERED BY MEDICARE IN JUL97";
label variable MCRAU97 "COVERED BY MEDICARE IN AUG97";
label variable MCRSE97 "COVERED BY MEDICARE IN SEPT97";
label variable MCROC97 "COVERED BY MEDICARE IN OCT97";
label variable MCRNO97 "COVERED BY MEDICARE IN NOV97";
label variable MCRDE97 "COVERED BY MEDICARE IN DEC97";
label variable MCRJA97X "COVERED BY MEDICARE IN JAN97 (ED)";
label variable MCRFE97X "COVERED BY MEDICARE IN FEB97 (ED)";
label variable MCRMA97X "COVERED BY MEDICARE IN MAR97 (ED)";
label variable MCRAP97X "COVERED BY MEDICARE IN APR97 (ED)";
label variable MCRMY97X "COVERED BY MEDICARE IN MAY97 (ED)";
label variable MCRJU97X "COVERED BY MEDICARE IN JUN97 (ED)";
label variable MCRJL97X "COVERED BY MEDICARE IN JUL97 (ED)";
label variable MCRAU97X "COVERED BY MEDICARE IN AUG97 (ED)";
label variable MCRSE97X "COVERED BY MEDICARE IN SEP97 (ED)";
label variable MCROC97X "COVERED BY MEDICARE IN OCT97 (ED)";
label variable MCRNO97X "COVERED BY MEDICARE IN NOV97 (ED)";
label variable MCRDE97X "COVERED BY MEDICARE IN DEC97 (ED)";
label variable MCDJA97 "COVERED BY MEDICAID IN JAN97";
label variable MCDFE97 "COVERED BY MEDICAID IN FEB97";
label variable MCDMA97 "COVERED BY MEDICAID IN MAR97";
label variable MCDAP97 "COVERED BY MEDICAID IN APR97";
label variable MCDMY97 "COVERED BY MEDICAID IN MAY97";
label variable MCDJU97 "COVERED BY MEDICAID IN JUN97";
label variable MCDJL97 "COVERED BY MEDICAID IN JUL97";
label variable MCDAU97 "COVERED BY MEDICAID IN AUG97";
label variable MCDSE97 "COVERED BY MEDICAID IN SEPT97";
label variable MCDOC97 "COVERED BY MEDICAID IN OCT97";
label variable MCDNO97 "COVERED BY MEDICAID IN NOV97";
label variable MCDDE97 "COVERED BY MEDICAID IN DEC97";
label variable MCDJA97X "COVERED BY MEDICAID IN JAN97 (ED)";
label variable MCDFE97X "COVERED BY MEDICAID IN FEB97 (ED)";
label variable MCDMA97X "COVERED BY MEDICAID IN MAR97 (ED)";
label variable MCDAP97X "COVERED BY MEDICAID IN APR97 (ED)";
label variable MCDMY97X "COVERED BY MEDICAID IN MAY97 (ED)";
label variable MCDJU97X "COVERED BY MEDICAID IN JUN97 (ED)";
label variable MCDJL97X "COVERED BY MEDICAID IN JUL97 (ED)";
label variable MCDAU97X "COVERED BY MEDICAID IN AUG97 (ED)";
label variable MCDSE97X "COVERED BY MEDICAID IN SEP97 (ED)";
label variable MCDOC97X "COVERED BY MEDICAID IN OCT97 (ED)";
label variable MCDNO97X "COVERED BY MEDICAID IN NOV97 (ED)";
label variable MCDDE97X "COVERED BY MEDICAID IN DEC97 (ED)";
label variable OPAJA97 "COV BY OTHER PUBLIC A INS IN JAN97";
label variable OPAFE97 "COV BY OTHER PUBLIC A INS IN FEB97";
label variable OPAMA97 "COV BY OTHER PUBLIC A INS IN MAR97";
label variable OPAAP97 "COV BY OTHER PUBLIC A INS IN APR97";
label variable OPAMY97 "COV BY OTHER PUBLIC A INS IN MAY97";
label variable OPAJU97 "COV BY OTHER PUBLIC A INS IN JUN97";
label variable OPAJL97 "COV BY OTHER PUBLIC A INS IN JUL97";
label variable OPAAU97 "COV BY OTHER PUBLIC A INS IN AUG97";
label variable OPASE97 "COV BY OTHER PUBLIC A INS IN SEP97";
label variable OPAOC97 "COV BY OTHER PUBLIC A INS IN OCT97";
label variable OPANO97 "COV BY OTHER PUBLIC A INS IN NOV97";
label variable OPADE97 "COV BY OTHER PUBLIC A INS IN DEC97";
label variable OPBJA97 "COV BY OTHER PUBLIC B INS IN JAN97";
label variable OPBFE97 "COV BY OTHER PUBLIC B INS IN FEB97";
label variable OPBMA97 "COV BY OTHER PUBLIC B INS IN MAR97";
label variable OPBAP97 "COV BY OTHER PUBLIC B INS IN APR97";
label variable OPBMY97 "COV BY OTHER PUBLIC B INS IN MAY97";
label variable OPBJU97 "COV BY OTHER PUBLIC B INS IN JUN97";
label variable OPBJL97 "COV BY OTHER PUBLIC B INS IN JUL97";
label variable OPBAU97 "COV BY OTHER PUBLIC B INS IN AUG97";
label variable OPBSE97 "COV BY OTHER PUBLIC B INS IN SEP97";
label variable OPBOC97 "COV BY OTHER PUBLIC B INS IN OCT97";
label variable OPBNO97 "COV BY OTHER PUBLIC B INS IN NOV97";
label variable OPBDE97 "COV BY OTHER PUBLIC B INS IN DEC97";
label variable STAJA97 "COVERED BY OTHER STATE PROG IN JAN97";
label variable STAFE97 "COVERED BY OTHER STATE PROG IN FEB97";
label variable STAMA97 "COVERED BY OTHER STATE PROG IN MAR97";
label variable STAAP97 "COVERED BY OTHER STATE PROG IN APR97";
label variable STAMY97 "COVERED BY OTHER STATE PROG IN MAY97";
label variable STAJU97 "COVERED BY OTHER STATE PROG IN JUN97";
label variable STAJL97 "COVERED BY OTHER STATE PROG IN JUL97";
label variable STAAU97 "COVERED BY OTHER STATE PROG IN AUG97";
label variable STASE97 "COVERED BY OTHER STATE PROG IN SEP97";
label variable STAOC97 "COVERED BY OTHER STATE PROG IN OCT97";
label variable STANO97 "COVERED BY OTHER STATE PROG IN NOV97";
label variable STADE97 "COVERED BY OTHER STATE PROG IN DEC97";
label variable PUBJA97X "COVRD BY ANY PUBLIC INS IN JAN97 (ED)";
label variable PUBFE97X "COVRD BY ANY PUBLIC INS IN FEB97 (ED)";
label variable PUBMA97X "COVRD BY ANY PUBLIC INS IN MAR97 (ED)";
label variable PUBAP97X "COVRD BY ANY PUBLIC INS IN APR97 (ED)";
label variable PUBMY97X "COVRD BY ANY PUBLIC INS IN MAY97 (ED)";
label variable PUBJU97X "COVRD BY ANY PUBLIC INS IN JUN97 (ED)";
label variable PUBJL97X "COVRD BY ANY PUBLIC INS IN JUL97 (ED)";
label variable PUBAU97X "COVRD BY ANY PUBLIC INS IN AUG97 (ED)";
label variable PUBSE97X "COVRD BY ANY PUBLIC INS IN SEP97 (ED)";
label variable PUBOC97X "COVRD BY ANY PUBLIC INS IN OCT97 (ED)";
label variable PUBNO97X "COVRD BY ANY PUBLIC INS IN NOV97 (ED)";
label variable PUBDE97X "COVRD BY ANY PUBLIC INS IN DEC97 (ED)";
label variable PEGJA97 "COVERED BY EMPL UNION INS IN JAN97";
label variable PEGFE97 "COVERED BY EMPL UNION INS IN FEB97";
label variable PEGMA97 "COVERED BY EMPL UNION INS IN MAR97";
label variable PEGAP97 "COVERED BY EMPL UNION INS IN APR97";
label variable PEGMY97 "COVERED BY EMPL UNION INS IN MAY97";
label variable PEGJU97 "COVERED BY EMPL UNION INS IN JUN97";
label variable PEGJL97 "COVERED BY EMPL UNION INS IN JUL97";
label variable PEGAU97 "COVERED BY EMPL UNION INS IN AUG97";
label variable PEGSE97 "COVERED BY EMPL UNION INS IN SEP97";
label variable PEGOC97 "COVERED BY EMPL UNION INS IN OCT97";
label variable PEGNO97 "COVERED BY EMPL UNION INS IN NOV97";
label variable PEGDE97 "COVERED BY EMPL UNION INS IN DEC97";
label variable PDKJA97 "COVRD BY PRIV INS (SOURCE UNKNWN) JAN97";
label variable PDKFE97 "COVRD BY PRIV INS (SOURCE UNKNWN) FEB97";
label variable PDKMA97 "COVRD BY PRIV INS (SOURCE UNKNWN) MAR97";
label variable PDKAP97 "COVRD BY PRIV INS (SOURCE UNKNWN) APR97";
label variable PDKMY97 "COVRD BY PRIV INS (SOURCE UNKNWN) MAY97";
label variable PDKJU97 "COVRD BY PRIV INS (SOURCE UNKNWN) JUN97";
label variable PDKJL97 "COVRD BY PRIV INS (SOURCE UNKNWN) JUL97";
label variable PDKAU97 "COVRD BY PRIV INS (SOURCE UNKNWN) AUG97";
label variable PDKSE97 "COVRD BY PRIV INS (SOURCE UNKNWN) SEP97";
label variable PDKOC97 "COVRD BY PRIV INS (SOURCE UNKNWN) OCT97";
label variable PDKNO97 "COVRD BY PRIV INS (SOURCE UNKNWN) NOV97";
label variable PDKDE97 "COVRD BY PRIV INS (SOURCE UNKNWN) DEC97";
label variable PNGJA97 "COVERED BY NONGROUP INS IN JAN97";
label variable PNGFE97 "COVERED BY NONGROUP INS IN FEB97";
label variable PNGMA97 "COVERED BY NONGROUP INS IN MAR97";
label variable PNGAP97 "COVERED BY NONGROUP INS IN APR97";
label variable PNGMY97 "COVERED BY NONGROUP INS IN MAY97";
label variable PNGJU97 "COVERED BY NONGROUP INS IN JUN97";
label variable PNGJL97 "COVERED BY NONGROUP INS IN JUL97";
label variable PNGAU97 "COVERED BY NONGROUP INS IN AUG97";
label variable PNGSE97 "COVERED BY NONGROUP INS IN SEP97";
label variable PNGOC97 "COVERED BY NONGROUP INS IN OCT97";
label variable PNGNO97 "COVERED BY NONGROUP INS IN NOV97";
label variable PNGDE97 "COVERED BY NONGROUP INS IN DEC97";
label variable POGJA97 "COVERED BY OTHER GROUP INS IN JAN97";
label variable POGFE97 "COVERED BY OTHER GROUP INS IN FEB97";
label variable POGMA97 "COVERED BY OTHER GROUP INS IN MAR97";
label variable POGAP97 "COVERED BY OTHER GROUP INS IN APR97";
label variable POGMY97 "COVERED BY OTHER GROUP INS IN MAY97";
label variable POGJU97 "COVERED BY OTHER GROUP INS IN JUN97";
label variable POGJL97 "COVERED BY OTHER GROUP INS IN JUL97";
label variable POGAU97 "COVERED BY OTHER GROUP INS IN AUG97";
label variable POGSE97 "COVERED BY OTHER GROUP INS IN SEP97";
label variable POGOC97 "COVERED BY OTHER GROUP INS IN OCT97";
label variable POGNO97 "COVERED BY OTHER GROUP INS IN NOV97";
label variable POGDE97 "COVERED BY OTHER GROUP INS IN DEC97";
label variable PRSJA97 "COVERED BY SELF-EMP-1 INS IN JAN97";
label variable PRSFE97 "COVERED BY SELF-EMP-1 INS IN FEB97";
label variable PRSMA97 "COVERED BY SELF-EMP-1 INS IN MAR97";
label variable PRSAP97 "COVERED BY SELF-EMP-1 INS IN APR97";
label variable PRSMY97 "COVERED BY SELF-EMP-1 INS IN MAY97";
label variable PRSJU97 "COVERED BY SELF-EMP-1 INS IN JUN97";
label variable PRSJL97 "COVERED BY SELF-EMP-1 INS IN JUL97";
label variable PRSAU97 "COVERED BY SELF-EMP-1 INS IN AUG97";
label variable PRSSE97 "COVERED BY SELF-EMP-1 INS IN SEP97";
label variable PRSOC97 "COVERED BY SELF-EMP-1 INS IN OCT97";
label variable PRSNO97 "COVERED BY SELF-EMP-1 INS IN NOV97";
label variable PRSDE97 "COVERED BY SELF-EMP-1 INS IN DEC97";
label variable POUJA97 "COVERED BY HOLDER OUTSIDE OF RU IN JAN97";
label variable POUFE97 "COVERED BY HOLDER OUTSIDE OF RU IN FEB97";
label variable POUMA97 "COVERED BY HOLDER OUTSIDE OF RU IN MAR97";
label variable POUAP97 "COVERED BY HOLDER OUTSIDE OF RU IN APR97";
label variable POUMY97 "COVERED BY HOLDER OUTSIDE OF RU IN MAY97";
label variable POUJU97 "COVERED BY HOLDER OUTSIDE OF RU IN JUN97";
label variable POUJL97 "COVERED BY HOLDER OUTSIDE OF RU IN JUL97";
label variable POUAU97 "COVERED BY HOLDER OUTSIDE OF RU IN AUG97";
label variable POUSE97 "COVERED BY HOLDER OUTSIDE OF RU IN SEP97";
label variable POUOC97 "COVERED BY HOLDER OUTSIDE OF RU IN OCT97";
label variable POUNO97 "COVERED BY HOLDER OUTSIDE OF RU IN NOV97";
label variable POUDE97 "COVERED BY HOLDER OUTSIDE OF RU IN DEC97";
label variable PRIJA97 "COVERED BY PRIVATE INS IN JAN97";
label variable PRIFE97 "COVERED BY PRIVATE INS IN FEB97";
label variable PRIMA97 "COVERED BY PRIVATE INS IN MAR97";
label variable PRIAP97 "COVERED BY PRIVATE INS IN APR97";
label variable PRIMY97 "COVERED BY PRIVATE INS IN MAY97";
label variable PRIJU97 "COVERED BY PRIVATE INS IN JUN97";
label variable PRIJL97 "COVERED BY PRIVATE INS IN JUL97";
label variable PRIAU97 "COVERED BY PRIVATE INS IN AUG97";
label variable PRISE97 "COVERED BY PRIVATE INS IN SEP97";
label variable PRIOC97 "COVERED BY PRIVATE INS IN OCT97";
label variable PRINO97 "COVERED BY PRIVATE INS IN NOV97";
label variable PRIDE97 "COVERED BY PRIVATE INS IN DEC97";
label variable HPEJA97 "HOLDER OF EMPL UNION INS IN JAN97";
label variable HPEFE97 "HOLDER OF EMPL UNION INS IN FEB97";
label variable HPEMA97 "HOLDER OF EMPL UNION INS IN MAR97";
label variable HPEAP97 "HOLDER OF EMPL UNION INS IN APR97";
label variable HPEMY97 "HOLDER OF EMPL UNION INS IN MAY97";
label variable HPEJU97 "HOLDER OF EMPL UNION INS IN JUN97";
label variable HPEJL97 "HOLDER OF EMPL UNION INS IN JUL97";
label variable HPEAU97 "HOLDER OF EMPL UNION INS IN AUG97";
label variable HPESE97 "HOLDER OF EMPL UNION INS IN SEP97";
label variable HPEOC97 "HOLDER OF EMPL UNION INS IN OCT97";
label variable HPENO97 "HOLDER OF EMPL UNION INS IN NOV97";
label variable HPEDE97 "HOLDER OF EMPL UNION INS IN DEC97";
label variable HPDJA97 "HOLDER OF PRIV INS (SOURCE UNKNWN) JAN97";
label variable HPDFE97 "HOLDER OF PRIV INS (SOURCE UNKNWN) FEB97";
label variable HPDMA97 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAR97";
label variable HPDAP97 "HOLDER OF PRIV INS (SOURCE UNKNWN) APR97";
label variable HPDMY97 "HOLDER OF PRIV INS (SOURCE UNKNWN) MAY97";
label variable HPDJU97 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUN97";
label variable HPDJL97 "HOLDER OF PRIV INS (SOURCE UNKNWN) JUL97";
label variable HPDAU97 "HOLDER OF PRIV INS (SOURCE UNKNWN) AUG97";
label variable HPDSE97 "HOLDER OF PRIV INS (SOURCE UNKNWN) SEP97";
label variable HPDOC97 "HOLDER OF PRIV INS (SOURCE UNKNWN) OCT97";
label variable HPDNO97 "HOLDER OF PRIV INS (SOURCE UNKNWN) NOV97";
label variable HPDDE97 "HOLDER OF PRIV INS (SOURCE UNKNWN) DEC97";
label variable HPNJA97 "HOLDER OF NONGROUP INS IN JAN97";
label variable HPNFE97 "HOLDER OF NONGROUP INS IN FEB97";
label variable HPNMA97 "HOLDER OF NONGROUP INS IN MAR97";
label variable HPNAP97 "HOLDER OF NONGROUP INS IN APR97";
label variable HPNMY97 "HOLDER OF NONGROUP INS IN MAY97";
label variable HPNJU97 "HOLDER OF NONGROUP INS IN JUN97";
label variable HPNJL97 "HOLDER OF NONGROUP INS IN JUL97";
label variable HPNAU97 "HOLDER OF NONGROUP INS IN AUG97";
label variable HPNSE97 "HOLDER OF NONGROUP INS IN SEP97";
label variable HPNOC97 "HOLDER OF NONGROUP INS IN OCT97";
label variable HPNNO97 "HOLDER OF NONGROUP INS IN NOV97";
label variable HPNDE97 "HOLDER OF NONGROUP INS IN DEC97";
label variable HPOJA97 "HOLDER OF OTHER GROUP INS IN JAN97";
label variable HPOFE97 "HOLDER OF OTHER GROUP INS IN FEB97";
label variable HPOMA97 "HOLDER OF OTHER GROUP INS IN MAR97";
label variable HPOAP97 "HOLDER OF OTHER GROUP INS IN APR97";
label variable HPOMY97 "HOLDER OF OTHER GROUP INS IN MAY97";
label variable HPOJU97 "HOLDER OF OTHER GROUP INS IN JUN97";
label variable HPOJL97 "HOLDER OF OTHER GROUP INS IN JUL97";
label variable HPOAU97 "HOLDER OF OTHER GROUP INS IN AUG97";
label variable HPOSE97 "HOLDER OF OTHER GROUP INS IN SEP97";
label variable HPOOC97 "HOLDER OF OTHER GROUP INS IN OCT97";
label variable HPONO97 "HOLDER OF OTHER GROUP INS IN NOV97";
label variable HPODE97 "HOLDER OF OTHER GROUP INS IN DEC97";
label variable HPSJA97 "HOLDER OF SELF-EMP-1 INS IN JAN97";
label variable HPSFE97 "HOLDER OF SELF-EMP-1 INS IN FEB97";
label variable HPSMA97 "HOLDER OF SELF-EMP-1 INS IN MAR97";
label variable HPSAP97 "HOLDER OF SELF-EMP-1 INS IN APR97";
label variable HPSMY97 "HOLDER OF SELF-EMP-1 INS IN MAY97";
label variable HPSJU97 "HOLDER OF SELF-EMP-1 INS IN JUN97";
label variable HPSJL97 "HOLDER OF SELF-EMP-1 INS IN JUL97";
label variable HPSAU97 "HOLDER OF SELF-EMP-1 INS IN AUG97";
label variable HPSSE97 "HOLDER OF SELF-EMP-1 INS IN SEP97";
label variable HPSOC97 "HOLDER OF SELF-EMP-1 INS IN OCT97";
label variable HPSNO97 "HOLDER OF SELF-EMP-1 INS IN NOV97";
label variable HPSDE97 "HOLDER OF SELF-EMP-1 INS IN DEC97";
label variable HPRJA97 "HOLDER OF PRIVATE INSURANCE IN JAN97";
label variable HPRFE97 "HOLDER OF PRIVATE INSURANCE IN FEB97";
label variable HPRMA97 "HOLDER OF PRIVATE INSURANCE IN MAR97";
label variable HPRAP97 "HOLDER OF PRIVATE INSURANCE IN APR97";
label variable HPRMY97 "HOLDER OF PRIVATE INSURANCE IN MAY97";
label variable HPRJU97 "HOLDER OF PRIVATE INSURANCE IN JUN97";
label variable HPRJL97 "HOLDER OF PRIVATE INSURANCE IN JUL97";
label variable HPRAU97 "HOLDER OF PRIVATE INSURANCE IN AUG97";
label variable HPRSE97 "HOLDER OF PRIVATE INSURANCE IN SEP97";
label variable HPROC97 "HOLDER OF PRIVATE INSURANCE IN OCT97";
label variable HPRNO97 "HOLDER OF PRIVATE INSURANCE IN NOV97";
label variable HPRDE97 "HOLDER OF PRIVATE INSURANCE IN DEC97";
label variable INSJA97X "COVRD BY HOSP/MED INS IN JAN97 (ED)";
label variable INSFE97X "COVRD BY HOSP/MED INS IN FEB97 (ED)";
label variable INSMA97X "COVRD BY HOSP/MED INS IN MAR97 (ED)";
label variable INSAP97X "COVRD BY HOSP/MED INS IN APR97 (ED)";
label variable INSMY97X "COVRD BY HOSP/MED INS IN MAY97 (ED)";
label variable INSJU97X "COVRD BY HOSP/MED INS IN JUN97 (ED)";
label variable INSJL97X "COVRD BY HOSP/MED INS IN JUL97 (ED)";
label variable INSAU97X "COVRD BY HOSP/MED INS IN AUG97 (ED)";
label variable INSSE97X "COVRD BY HOSP/MED INS IN SEP97 (ED)";
label variable INSOC97X "COVRD BY HOSP/MED INS IN OCT97 (ED)";
label variable INSNO97X "COVRD BY HOSP/MED INS IN NOV97 (ED)";
label variable INSDE97X "COVRD BY HOSP/MED INS IN DEC97 (ED)";
label variable PRVEV97 "EVER HAVE PRIVATE INSURANCE DURING 97";
label variable CHPEV97 "EVER HAVE CHAMPUS/CHAMPVA DURING 97";
label variable MCDEV97 "EVER HAVE MEDICAID DURING 97";
label variable MCREV97 "EVER HAVE MEDICARE DURING 97";
label variable OPAEV97 "EVER HAVE OTHER PUBLIC A INS DURING 97";
label variable OPBEV97 "EVER HAVE OTHER PUBLIC B INS DURING 97";
label variable UNINS97 "UNINSURED ALL OF 97";
label variable INSCOV97 "HEALTH INSURANCE COVERAGE INDICATOR 97";
label variable RTHLTH31 "PERCEIVED HEALTH STATUS - RD 3/1";
label variable RTHLTH42 "PERCEIVED HEALTH STATUS - RD 4/2";
label variable RTHLTH53 "PERCEIVED HEALTH STATUS - RD 5/3";
label variable RTPROX31 "SELF/PROXY RATING OF HEALTH - RD 3/1";
label variable RTPROX42 "SELF/PROXY RATING OF HEALTH - RD 4/2";
label variable RTPROX53 "SELF/PROXY RATING OF HEALTH - RD 5/3";
label variable MNHLTH31 "PERCEIVED MENTAL HEALTH STATUS - RD 3/1";
label variable MNHLTH42 "PERCEIVED MENTAL HEALTH STATUS - RD 4/2";
label variable MNHLTH53 "PERCEIVED MENTAL HEALTH STATUS - RD 5/3";
label variable MNPROX31 "SELF/PROXY RATING OF MENTAL HEALTH-R3/1";
label variable MNPROX42 "SELF/PROXY RATING OF MENTAL HEALTH-R4/2";
label variable MNPROX53 "SELF/PROXY RATING OF MENTAL HEALTH-R5/3";
label variable IADLHP31 "IADL SCREENER - RD 3/1";
label variable IADLHP42 "IADL SCREENER - RD 4/2";
label variable IADLHP53 "IADL SCREENER - RD 5/3";
label variable ADLHLP31 "ADL SCREENER - RD 3/1";
label variable ADLHLP42 "ADL SCREENER - RD 4/2";
label variable ADLHLP53 "ADL SCREENER - RD 5/3";
label variable AIDHLP31 "USED ASSISTIVE DEVICES - RD 3/1";
label variable AIDHLP53 "USED ASSISTIVE DEVICES - RD 5/3";
label variable WLKLIM31 "LIMITATION IN PHYSICAL FUNCTIONING-RD3/1";
label variable WLKLIM53 "LIMITATION IN PHYSICAL FUNCTIONING-RD5/3";
label variable LFTDIF31 "DIFFICULTY LIFTING 10 POUNDS - RD 3/1";
label variable LFTDIF53 "DIFFICULTY LIFTING 10 POUNDS - RD 5/3";
label variable STPDIF31 "DIFFICULTY WALKING UP 10 STEPS - RD 3/1";
label variable STPDIF53 "DIFFICULTY WALKING UP 10 STEPS - RD 5/3";
label variable WLKDIF31 "DIFFICULTY WALKING 3 BLOCKS - RD 3/1";
label variable WLKDIF53 "DIFFICULTY WALKING 3 BLOCKS - RD 5/3";
label variable MILDIF31 "DIFFICULTY WALKING A MILE - RD 3/1";
label variable MILDIF53 "DIFFICULTY WALKING A MILE - RD 5/3";
label variable STNDIF31 "DIFFICULTY STANDING 20 MINUTES - RD 3/1";
label variable STNDIF53 "DIFFICULTY STANDING 20 MINUTES - RD 5/3";
label variable BENDIF31 "DIFFICULTY BENDING/STOOPING - RD 3/1";
label variable BENDIF53 "DIFFICULTY BENDING/STOOPING - RD 5/3";
label variable RCHDIF31 "DIFFICULTY REACHING OVERHEAD - RD 3/1";
label variable RCHDIF53 "DIFFICULTY REACHING OVERHEAD - RD 5/3";
label variable FNGRDF31 "DIFFICULTY USING FINGERS TO GRASP-RD 3/1";
label variable FNGRDF53 "DIFFICULTY USING FINGERS TO GRASP-RD 5/3";
label variable ACTLIM31 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 3/1";
label variable ACTLIM53 "ANY LIMITATION WORK/HOUSEWRK/SCHL-RD 5/3";
label variable WRKLIM31 "WORK LIMITATION - RD 3/1";
label variable WRKLIM53 "WORK LIMITATION - RD 5/3";
label variable HSELIM31 "HOUSEWORK LIMITATION - RD 3/1";
label variable HSELIM53 "HOUSEWORK LIMITATION - RD 5/3";
label variable SCHLIM31 "SCHOOL LIMITATION - RD 3/1";
label variable SCHLIM53 "SCHOOL LIMITATION - RD 5/3";
label variable UNABLE31 "COMPLETELY UNABLE TO DO ACTIVITY-RD 3/1";
label variable UNABLE53 "COMPLETELY UNABLE TO DO ACTIVITY-RD 5/3";
label variable SOCLIM31 "SOCIAL LIMITATIONS - RD 3/1";
label variable SOCLIM53 "SOCIAL LIMITATIONS - RD 5/3";
label variable COGLIM31 "COGNITIVE LIMITATIONS - RD 3/1";
label variable COGLIM53 "COGNITIVE LIMITATIONS - RD 5/3";
label variable WRGLAS42 "WEARS EYEGLASSES OR CONTACTS - RD 4/2";
label variable SEEDIF42 "DIFFCLTY SEEING W/GLASSES/CNTCTS-RD 4/2";
label variable BLIND42 "PERSON IS BLIND - RD 4/2";
label variable READNW42 "CAN READ NEWSPRNT W/GLASSES/CNTCTS-RD4/2";
label variable RECPEP42 "CAN RECGNZE PEOPLE W/GLASSES/CNTCTS-R4/2";
label variable VISION42 "VISION IMPAIRMENT (SUMMARY) - RD 4/2";
label variable HEARAD42 "PERSON WEARS HEARING AID - RD 4/2";
label variable HEARDI42 "ANY DIFFCLTY HEARING W/HEARING AID-RD4/2";
label variable DEAF42 "PERSON IS DEAF - RD 4/2";
label variable HEARMO42 "CAN HEAR MOST CONVERSATION - RD 4/2";
label variable HEARSM42 "CAN HEAR SOME CONVERSATION - RD 4/2";
label variable HEARNG42 "HEARING IMPAIRMENT (SUMMARY) - RD 4/2";
label variable ANYLIM97 "ANY LIMITATION - RD 3/1 & RD 4/2";
label variable LIMACT42 "LIMITED IN ANY ACTIVITIES (<5 YR)-RD 4/2";
label variable PLYLIM42 "LIMITED IN PLAY ACTIVITY (<5 YRS)-RD 4/2";
label variable CANTPL42 "CAN T PARTICIPATE USUAL PLAY(<5 YR)-R4/2";
label variable SPCPRO42 "IN SPECIAL PROGRAM (<5 YEARS) - RD 4/2";
label variable DPTSHT42 "IMMUNIZATION FOR DPT (<7 YEARS) - RD 4/2";
label variable NUMDPT42 "ONE OR SEVERAL DPT SHOTS (<7 YRS)-RD 4/2";
label variable POLSHT42 "IMMUNIZATION FOR POLIO (<7 YEARS)-RD 4/2";
label variable NUMPOL42 "ONE OR SEVERAL POLIO SHOTS (<7 YR)-RD4/2";
label variable MMRSHT42 "IMMUNIZATION MEASLES/MUMPS/RUBELLA- R4/2";
label variable HEPSHT42 "IMMUNIZATION FOR HEPATITIS (<7 YR)-RD4/2";
label variable MOMPRO42 "PROBLEM GETTING ALONG W/MOM (5-17)-RD4/2";
label variable DADPRO42 "PROBLEM GETTING ALONG W/DAD (5-17)-RD4/2";
label variable UNHAP42 "PROBLEM FEELING UNHAPPY/SAD (5-17)-RD4/2";
label variable SCHLBH42 "PROBLEM BEHAVIOR AT SCHOOL (5-17)-RD 4/2";
label variable HAVFUN42 "PROBLEM HAVING FUN (5-17) - RD 4/2";
label variable ADUPRO42 "PRBLM GETTING ALONG W/ADULTS (5-17)-R4/2";
label variable NERVAF42 "PRBLM FEELING NERVOUS/AFRAID (5-17)-R4/2";
label variable SIBPRO42 "PROBLEM GETTING ALONG W/SIB (5-17)-RD4/2";
label variable KIDPRO42 "PRBLM GETTING ALONG W/KIDS (5-17) - R4/2";
label variable SPRPRO42 "PROBLEM W/SPORTS/HOBBIES (5-17) - RD 4/2";
label variable SCHPRO42 "PROBLEM WITH SCHOOLWORK (5-17)-RD 4/2";
label variable HOMEBH42 "PROBLEM W/BEHAVIOR AT HOME (5-17)-RD 4/2";
label variable TRBLE42 "PROBLEM STAYING OUT OF TROUBLE - RD 4/2";
label variable SPCSCH42 "NEED SPECIAL SCHOOL PROGRAM (5-17)-RD4/2";
label variable SPECED42 "IN SPECIAL EDUCATION (5-17) - RD 4/2";
label variable SPCHTH42 "RECEIVED SPEECH THERAPY (5-17) - RD 4/2";
label variable PSYCNS42 "PSYCHOLOGICAL COUNSELING - RD 4/2";
label variable OCUPTH42 "RECEIVED OCCUPATIONAL THRPY (5-17)-R4/2";
label variable VOCSVC42 "RECEIVED VOCATIONAL SERVICES (5-17)-R4/2";
label variable TUTOR42 "RECEIVED TUTORING (5-17) - RD 4/2";
label variable READIN42 "USES READER OR INTERPRETER (5-17)-RD 4/2";
label variable PHYTHR42 "RECEIVED PHYSICAL THERAPY (5-17)-RD 4/2";
label variable LIFSKL42 "RECEIVED LIFE SKILLS TRAINING(5-17)-R4/2";
label variable FAMCNS42 "RECEIVED FAMILY COUNSELING (5-17)-RD 4/2";
label variable RECTHR42 "RECEIVED RECREATIONAL THRPY (5-17) -R4/2";
label variable OTHSVC42 "RECEIVED OTH SCHOOL SERVICE (5-17)-RD4/2";
label variable CANTSC42 "LIMITED/UNABLE GO TO SCHOOL (5-17) -R4/2";
label variable LMOACT42 "LIMTED IN NON-SCHOOL ACTIVITY(5-17)-R4/2";
label variable HLTHY42 "CHILD RESISTS ILLNESS WELL (0-17)-RD 4/2";
label variable NTHLTH42 "LESS HLTHY THAN SAME AGE KIDS(0-17)-R4/2";
label variable GETSIC42 "CHILD CATCHES WHAT S AROUND (0-17) -R4/2";
label variable HGTFT42 "CHILD S HEIGHT - FEET (0-17) - RD 4/2";
label variable HGTIN42 "CHILD S HEIGHT - INCHES (0-17) - RD 4/2";
label variable WGTLB42 "CHILD S WEIGHT - POUNDS (0-17) - RD 4/2";
label variable WGTOZ42 "CHILD S WEIGHT - OUNCES (0-17) - RD 4/2";
label variable CHLIM42 "CHILD HAS ANY LIMITATION (0-17) - RD 4/2";
label variable TOTTCH97 "TOTAL HEALTH CARE CHARGES 97, EXCL. RX";
label variable TOTEXP97 "TOTAL HEALTH CARE EXP 97";
label variable TOTSLF97 "TOTAL AMT PAID BY SELF/FAMILY 97";
label variable TOTMCR97 "TOTAL AMT PAID BY MEDICARE 97";
label variable TOTMCD97 "TOTAL AMT PAID BY MEDICAID 97";
label variable TOTPRV97 "TOTAL AMT PAID BY PRIVATE INS 97";
label variable TOTVA97 "TOTL AMT PAID BY VA 97";
label variable TOTCHM97 "TOTL AMT PAID BY CHAMPUS/CHAMPVA 97";
label variable TOTOFD97 "TOTL AMT PAID BY OTHER FEDERAL 97";
label variable TOTSTL97 "TOTL AMT PAID BY OTH ST/LOCAL 97";
label variable TOTWCP97 "TOTL AMT PAID BY WORKERS COMP 97";
label variable TOTOPR97 "TOTL AMT PAID BY OTHER PRIVATE 97";
label variable TOTOPU97 "TOTL AMT PAID BY OTHER PUBLIC 97";
label variable TOTOSR97 "TOTL AMT PAID BY OTHER SOURCES 97";
label variable OBTOTV97 "# OFFICE-BASED PROVIDER VISITS 97";
label variable OBVTCH97 "OFFICE-BASED PROVIDER VISIT CHARGES 97";
label variable OBVEXP97 "TOTAL OFFICE-BASED EXP 97";
label variable OBVSLF97 "ALL OFFICE VISITS -SELF/FAMILY AMT 97";
label variable OBVMCR97 "ALL OFFICE VISITS -MEDICARE AMT 97";
label variable OBVMCD97 "ALL OFFICE VISITS -MEDICAID AMT 97";
label variable OBVPRV97 "ALL OFFICE VISITS -PRIVATE INS AMT 97";
label variable OBVVA97 "ALL OFFICE VISITS-VA AMT 97";
label variable OBVCHM97 "ALL OFFICE VISITS-CHAMPUS/CHAMPVA AMT 97";
label variable OBVOFD97 "ALL OFFICE VISITS-OTHER FEDERAL AMT 97";
label variable OBVSTL97 "ALL OFFICE VISITS-OTH ST/LOCAL AMT 97";
label variable OBVWCP97 "ALL OFFICE VISITS -WORKERS COMP AMT 97";
label variable OBVOPR97 "ALL OFFICE VISITS - OTH PRIVATE AMT 97";
label variable OBVOPU97 "ALL OFFICE VISITS - OTH PUBLIC AMT 97";
label variable OBVOSR97 "ALL OFF VSTS - OTH UNCLASS SRCE AMT 97";
label variable OBDRV97 "# OFFICE-BASED PHYSICIAN VISITS 97";
label variable OBDTCH97 "OFFICE-BASED PHYSICIAN VISIT CHARGES 97";
label variable OBDEXP97 "TOTAL OFF-BASED DR EXP 97";
label variable OBDSLF97 "DR OFFICE VISITS -SELF/FAMILY AMT 97";
label variable OBDMCR97 "DR OFFICE VISITS -MEDICARE AMT 97";
label variable OBDMCD97 "DR OFFICE VISITS -MEDICAID AMT 97";
label variable OBDPRV97 "DR OFFICE VISITS -PRIVATE INS AMT 97";
label variable OBDVA97 "DR OFFICE VISITS -VA AMT 97";
label variable OBDCHM97 "DR OFFICE VISITS-CHAMPUS/CHAMPVA AMT 97";
label variable OBDOFD97 "DR OFFICE VISITS -OTHER FEDERAL AMT 97";
label variable OBDSTL97 "DR OFFICE VISITS -OTH ST/LOCAL AMT 97";
label variable OBDWCP97 "DR OFFICE VISITS -WORKERS COMP AMT 97";
label variable OBDOPR97 "DR OFFICE VISITS - OTH PRIVATE AMT 97";
label variable OBDOPU97 "DR OFFICE VISITS - OTH PUBLIC AMT 97";
label variable OBDOSR97 "DR OFF VSTS - OTH UNCLASS SRCE AMT 97";
label variable OBOTHV97 "# OFFICE-BASED NON-PHYSICAN VISITS 97";
label variable OBOTCH97 "OFFICE-BASED NON-DR VISIT CHARGES 97";
label variable OBOEXP97 "TOTAL OFF-BASED NON-DR EXP 97";
label variable OBOSLF97 "NON-DR OFF VISTS -SELF/FAMILY AMT 97";
label variable OBOMCR97 "NON-DR OFF VISTS -MEDICARE AMT 97";
label variable OBOMCD97 "NON-DR OFF VISTS -MEDICAID AMT 97";
label variable OBOPRV97 "NON-DR OFF VISTS -PRIVATE INS AMT 97";
label variable OBOVA97 "NON-DR OFF VISTS -VA AMT 97";
label variable OBOCHM97 "NON-DR OFF VISTS-CHAMPUS/CHAMPVA AMT 97";
label variable OBOOFD97 "NON-DR OFF VISTS -OTHER FEDERAL AMT 97";
label variable OBOSTL97 "NON-DR OFF VISTS -OTH ST/LOCAL AMT 97";
label variable OBOWCP97 "NON-DR OFF VISTS -WORKERS COMP AMT 97";
label variable OBOOPR97 "NON-DR OFF VISTS - OTH PRIVATE AMT 97";
label variable OBOOPU97 "NON-DR OFF VISTS - OTH PUBLIC AMT 97";
label variable OBOOSR97 "NON-DR OF VSTS - OTH UNCLASS SRCE AMT 97";
label variable OBCHIR97 "# OFFICE-BASED CHIROPRACTOR VISITS 97";
label variable OBCTCH97 "OFFICE-BASED CHIRO VISIT CHARGES 97";
label variable OBCEXP97 "TOTAL OFF-BASED CHIRO EXP 97";
label variable OBCSLF97 "CHIRO OFF VISITS -SELF/FAMILY AMT 97";
label variable OBCMCR97 "CHIRO OFF VISITS -MEDICARE AMT 97";
label variable OBCMCD97 "CHIRO OFF VISITS -MEDICAID AMT 97";
label variable OBCPRV97 "CHIRO OFF VISITS -PRIVATE INS AMT 97";
label variable OBCVA97 "CHIRO OFF VISITS -VA AMT 97";
label variable OBCCHM97 "CHIRO OFF VISITS-CHAMPUS/CHAMPVA AMT 97";
label variable OBCOFD97 "CHIRO OFF VISITS -OTHER FEDERAL AMT 97";
label variable OBCSTL97 "CHIRO OFF VISITS -OTH ST/LOCAL AMT 97";
label variable OBCWCP97 "CHIRO OFF VISITS -WORKERS COMP AMT 97";
label variable OBCOPR97 "CHIRO OFF VISTS - OTHR PRIVATE AMT 97";
label variable OBCOPU97 "CHIRO OFF VISTS - OTHR PUBLIC AMT 97";
label variable OBCOSR97 "CHIRO OF VSTS - OTHR UNCLASS SRCE AMT 97";
label variable OBNURS97 "# OFF-BASED NURSE/PRACTITIONER VISITS 97";
label variable OBNTCH97 "OFFICE-BASED NURSE/PRAC VISIT CHARGES 97";
label variable OBNEXP97 "TOTAL OFF-BASED NURSE/PRAC 97";
label variable OBNSLF97 "NURSE/PRAC OFF VISITS-SELF/FAMILY AMT 97";
label variable OBNMCR97 "NURSE/PRAC OFF VISITS -MEDICARE AMT 97";
label variable OBNMCD97 "NURSE/PRAC OFF VSTS -MEDICAID AMT 97";
label variable OBNPRV97 "NURSE/PRAC OFF VSTS -PRIVATE INS AMT 97";
label variable OBNVA97 "NURSE/PRAC OFF VSTS-VA AMT 97";
label variable OBNCHM97 "NURSE/PRAC OFF VSTS-CHMPUS/CHMPVA AMT 97";
label variable OBNOFD97 "NURSE/PRAC OFF VSTS-OTHER FEDERAL AMT 97";
label variable OBNSTL97 "NURSE/PRAC OFF VSTS -OTH ST/LOCAL AMT 97";
label variable OBNWCP97 "NURSE/PRAC OFF VSTS -WORKERS COMP AMT 97";
label variable OBNOPR97 "NURSE/PRAC OFF VSTS - OTH PRIVATE AMT 97";
label variable OBNOPU97 "NURSE/PRAC OFF VSTS - OTH PUBLIC AMT 97";
label variable OBNOSR97 "NRS/PR OF VSTS - OTH UNCLASS SRCE AMT 97";
label variable OBOPTO97 "# OFF-BASED OPTOMETRIST VISITS 97";
label variable OBETCH97 "OFFICE-BASED OPTOMTRIST VISIT CHARGES 97";
label variable OBEEXP97 "TOTAL OFF-BASED OPOTMETRIST EXP 97";
label variable OBESLF97 "OPTOMETRIST OFF VSTS -SELF/FAMILY AMT 97";
label variable OBEMCR97 "OPTOMETRIST OFF VSTS -MEDICARE AMT 97";
label variable OBEMCD97 "OPTOMETRIST OFF VSTS -MEDICAID AMT 97";
label variable OBEPRV97 "OPTOMETRIST OFF VSTS -PRIVATE INS AMT 97";
label variable OBEVA97 "OPTOMETRIST OFF VSTS -VA AMT 97";
label variable OBECHM97 "OPTOMETRIST OFF VSTS-CHMPUS/CHPVA AMT 97";
label variable OBEOFD97 "OPTOMETRIST OFF VSTS-OTH FEDERAL AMT 97";
label variable OBESTL97 "OPTOMETRIST OFF VSTS -OTH ST/LOCL AMT 97";
label variable OBEWCP97 "OPTOMETRIST OFF VSTS-WORKERS COMP AMT 97";
label variable OBEOPR97 "OPTOMETRIST OFF VSTS -OTH PRIVATE AMT 97";
label variable OBEOPU97 "OPTOMETRIST OFF VSTS -OTH PUBLIC AMT 97";
label variable OBEOSR97 "OPTOM OF VSTS - OTH UNCLASS SRCE AMT 97";
label variable OBASST97 "# OFF-BASED PHYSICIAN ASSIST VISITS 97";
label variable OBATCH97 "OFFICE-BASED PHYS ASST VISIT CHARGES 97";
label variable OBAEXP97 "TOTAL OFF-BASED PHYS ASS T EXP 97";
label variable OBASLF97 "PHYS ASS T OFF VSTS-SELF/FAMILY AMT 97";
label variable OBAMCR97 "PHYS ASS T OFF VSTS-MEDICARE AMT 97";
label variable OBAMCD97 "PHYS ASS T OFF VSTS-MEDICAID AMT 97";
label variable OBAPRV97 "PHYS ASS T OFF VSTS-PRIVATE INS AMT 97";
label variable OBAVA97 "PHYS ASS T OFF VSTS-VA AMT 97";
label variable OBACHM97 "PHYS ASS T OFF VSTS-CHMPUS/CHMPVA AMT 97";
label variable OBAOFD97 "PHYS ASS T OFF VSTS -OTHER FED AMT 97";
label variable OBASTL97 "PHYS ASS T OFF VSTS -OTH ST/LOCL AMT 97";
label variable OBAWCP97 "PHYS ASS T OFF VSTS-WORKERS COMP AMT 97";
label variable OBAOPR97 "PHYS ASS T OFF VSTS - OTH PRIVATE AMT 97";
label variable OBAOPU97 "PHYS ASS T OFF VSTS - OTH PUBLIC AMT 97";
label variable OBAOSR97 "P A OFF VSTS - OTH UNCLASS SRCE AMT 97";
label variable OBTHER97 "# OFF-BASED PT/OT VISITS 97";
label variable OBTTCH97 "OFFICE-BASED PT/OC VISIT CHARGES 97";
label variable OBTEXP97 "TOT OFF-BASED PT EXP 97";
label variable OBTSLF97 "PT/OT OFF VISITS-SELF/FAMILY AMT 97";
label variable OBTMCR97 "PT/OT OFF VISITS-MEDICARE AMT 97";
label variable OBTMCD97 "PT/OT OFF VISITS-MEDICAID AMT 97";
label variable OBTPRV97 "PT/OT OFF VISITS-PRIVATE INS AMT 97";
label variable OBTVA97 "PT/OT OFF VISITS-VA AMT 97";
label variable OBTCHM97 "PT/OT OFF VISITS-CHAMPUS/CHAMPVA AMT 97";
label variable OBTOFD97 "PT/OT OFF VISITS -OTHER FED AMT 97";
label variable OBTSTL97 "PT/OT OFF VISITS-OTH ST/LOCL AMT 97";
label variable OBTWCP97 "PT/OT OFF VISITS-WORKERS COMP AMT 97";
label variable OBTOPR97 "PT/OT OFF VISITS - OTH PRIVATE AMT 97";
label variable OBTOPU97 "PT/OT OFF VISITS - OTH PUBLIC AMT 97";
label variable OBTOSR97 "PT/OT OF VSTS-OTH UNCLASS SRCE AMT 97";
label variable OPTOTV97 "# OUTPATIENT DEPT PROVIDER VISITS 97";
label variable OPFTCH97 "OPD PROVIDER VISIT CHARGES - FAC 97";
label variable OPFEXP97 "TOTAL OUTPATIENT FACILITY EXP 97";
label variable OPFSLF97 "ALL OPD VISITS-SELF/FAMILY AMT-FAC 97";
label variable OPFMCR97 "ALL OPD VISITS-MEDICARE AMT-FAC 97";
label variable OPFMCD97 "ALL OPD VISITS-MEDICAID AMT-FAC 97";
label variable OPFPRV97 "ALL OPD VISITS-PRIV INS AMT-FAC 97";
label variable OPFVA97 "ALL OPD VISITS-VA AMT-FAC 97";
label variable OPFCHM97 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-FAC 97";
label variable OPFOFD97 "ALL OPD VISITS-OTHER FED AMT-FAC 97";
label variable OPFSTL97 "ALL OPD VISITS-OTH ST/LOCAL AMT-FAC 97";
label variable OPFWCP97 "ALL OPD VISITS-WORKERS COMP AMT-FAC 97";
label variable OPFOPR97 "ALL OPD VISITS - OTH PRIVATE AMT-FAC 97";
label variable OPFOPU97 "ALL OPD VISITS - OTH PUBLIC AMT-FAC 97";
label variable OPFOSR97 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-FAC 97";
label variable OPDEXP97 "TOTAL OUTPATIENT PROVIDER EXP 97";
label variable OPDTCH97 "OPD PROVIDER VISIT CHARGES - DR 97";
label variable OPDSLF97 "ALL OPD VISITS-SELF/FAMILY AMT-DR 97";
label variable OPDMCR97 "ALL OPD VISITS-MEDICARE AMT -DR 97";
label variable OPDMCD97 "ALL OPD VISITS-MEDICAID AMT -DR 97";
label variable OPDPRV97 "ALL OPD VISITS-PRIV INS AMT-DR 97";
label variable OPDVA97 "ALL OPD VISITS-VA AMT-DR 97";
label variable OPDCHM97 "ALL OPD VISITS-CHMPUS/CHMPVA AMT-DR 97";
label variable OPDOFD97 "ALL OPD VISITS-OTHER FED AMT-DR 97";
label variable OPDSTL97 "ALL OPD VISITS-OTH ST/LOCAL AMT-DR 97";
label variable OPDWCP97 "ALL OPD VISITS-WORKERS COMP AMT-DR 97";
label variable OPDOPR97 "ALL OPD VISITS - OTH PRIVATE AMT-DR 97";
label variable OPDOPU97 "ALL OPD VISITS-OTH PUBLIC AMT-DR 97";
label variable OPDOSR97 "ALL OPD VSTS-OTH UNCLASS SRCE AMT-DR 97";
label variable OPDRV97 "# OUTPATIENT DEPT PHYSICIAN VISITS 97";
label variable OPVTCH97 "OPD PHYSICIAN VISIT CHARGES - FAC 97";
label variable OPVEXP97 "TOTAL OUTPATIENT PHYSICIAN - FAC EXP 97";
label variable OPVSLF97 "OPD DR VISITS-SELF/FAMILY AMT-FAC 97";
label variable OPVMCR97 "OPD DR VISITS-MEDICARE AMT-FAC 97";
label variable OPVMCD97 "OPD DR VISITS-MEDICAID AMT-FAC 97";
label variable OPVPRV97 "OPD DR VISITS-PRIV INS AMT-FAC 97";
label variable OPVVA97 "OPD DR VISITS-VA AMT-FAC 97";
label variable OPVCHM97 "OPD DR VISITS-CHPUS/CHPVA AMT-FAC 97";
label variable OPVOFD97 "OPD DR VISITS-OTHER FED AMT-FAC 97";
label variable OPVSTL97 "OPD DR VISITS-OTH ST/LOCAL AMT-FAC 97";
label variable OPVWCP97 "OPD DR VISITS-WORKERS COMP AMT-FAC 97";
label variable OPVOPR97 "OPD DR VISITS - OTH PRIVATE AMT-FAC 97";
label variable OPVOPU97 "OPD DR VISITS-OTH PUBLIC AMT-FAC 97";
label variable OPVOSR97 "OPD DR VSTS-OTH UNCLASS SRCE AMT-FAC 97";
label variable OPSEXP97 "TOTAL OUTPATIENT PHYSICIAN - DR EXP 97";
label variable OPSTCH97 "OPD PHYSICIAN VISIT CHARGES - DR 97";
label variable OPSSLF97 "OPD DR VISITS-SELF/FAMILY AMT-DR 97";
label variable OPSMCR97 "OPD DR VISITS-MEDICARE AMT-DR 97";
label variable OPSMCD97 "OPD DR VISITS-MEDICAID AMT-DR 97";
label variable OPSPRV97 "OPD DR VISITS-PRIV INS AMT-DR 97";
label variable OPSVA97 "OPD DR VISITS-VA AMT-DR 97";
label variable OPSCHM97 "OPD DR VISITS-CHMPUS/CHMPVA AMT-DR 97";
label variable OPSOFD97 "OPD DR VISITS-OTHER FED AMT-DR 97";
label variable OPSSTL97 "OPD DR VISITS-OTH ST/LOCAL AMT-DR 97";
label variable OPSWCP97 "OPD DR VISITS-WORKERS COMP AMT-DR 97";
label variable OPSOPR97 "OPD DR VISITS - OTH PRIVATE AMT-DR 97";
label variable OPSOPU97 "OPD DR VISITS-OTH PUBLIC AMT-DR 97";
label variable OPSOSR97 "OPD DR VSTS-OTH UNCLASS SRCE AMT-DR 97";
label variable OPOTHV97 "# OUTPATIENT DEPT NON-DR VISITS 97";
label variable OPOTCH97 "OPD NON-PHYS VISIT CHARGES - FAC 97";
label variable OPOEXP97 "TOTAL OUTPATIENT NON-DR - FAC EXP 97";
label variable OPOSLF97 "OPD NON-DR VISITS-SELF/FAM AMT-FAC 97";
label variable OPOMCR97 "OPD NON-DR VISITS-MEDICARE AMT-FAC 97";
label variable OPOMCD97 "OPD NON-DR VISITS-MEDICAID AMT-FAC 97";
label variable OPOPRV97 "OPD NON-DR VISITS-PRIV INS AMT-FAC 97";
label variable OPOVA97 "OPD NON-DR VISITS-VA AMT-FAC 97";
label variable OPOCHM97 "OPD NON-DR VISITS-CHPS/CHVA AMT-FAC 97";
label variable OPOOFD97 "OPD NON-DR VISITS-OTHER FED AMT-FAC 97";
label variable OPOSTL97 "OPD NON-DR VISITS-OTH ST/LOC AMT-FAC 97";
label variable OPOWCP97 "OPD NON-DR VISITS-WRKRS COMP AMT-FAC 97";
label variable OPOOPR97 "OPD NON-DR VISITS-OTH PRIVATE AMT-FAC 97";
label variable OPOOPU97 "OPD NON-DR VISITS-OTH PUBLIC AMT-FAC 97";
label variable OPOOSR97 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-FAC 97";
label variable OPPEXP97 "TOTAL OUTPATIENT NON-DR - DR EXP 97";
label variable OPPTCH97 "OPD NON-PHYS VISIT CHARGES - DR 97";
label variable OPPSLF97 "OPD NON-DR VISITS-SELF/FAM AMT-DR 97";
label variable OPPMCR97 "OPD NON-DR VISITS-MEDICARE AMT-DR 97";
label variable OPPMCD97 "OPD NON-DR VISITS-MEDICAID AMT-DR 97";
label variable OPPPRV97 "OPD NON-DR VISITS-PRIV INS AMT-DR 97";
label variable OPPVA97 "OPD NON-DR VISITS-VA AMT-DR 97";
label variable OPPCHM97 "OPD NON-DR VISITS-CHPS/CHVA AMT-DR 97";
label variable OPPOFD97 "OPD NON-DR VISITS-OTHER FED AMT-DR 97";
label variable OPPSTL97 "OPD NON-DR VISITS-OTH ST/LOC AMT-DR 97";
label variable OPPWCP97 "OPD NON-DR VISITS-WRKRS COMP AMT-DR 97";
label variable OPPOPR97 "OPD NON-DR VISITS-OTH PRIVATE AMT-DR 97";
label variable OPPOPU97 "OPD NON-DR VISITS-OTH PUBLIC AMT-DR 97";
label variable OPPOSR97 "OPD NON-DR VSTS-OT UNCLAS SRC AMT-DR 97";
label variable AMCHIR97 "# CHIROPRACTR VSTS (OFF+OUTPAT), 1997";
label variable AMCTCH97 "CHIRO AMBULATORY VISIT CHARGES 97";
label variable AMCEXP97 "TOTL AMBULTRY (OB+OP) CHIRO EXP 97";
label variable AMCSLF97 "CHIRO AMB VISITS -SELF/FAMILY AMT 97";
label variable AMCMCR97 "CHIRO AMB VISITS -MEDICARE AMT 97";
label variable AMCMCD97 "CHIRO AMB VISITS -MEDICAID AMT 97";
label variable AMCPRV97 "CHIRO AMB VISITS -PRIVATE INS AMT 97";
label variable AMCVA97 "CHIRO AMB VISITS -VA AMT 97";
label variable AMCCHM97 "CHIRO AMB VISITS-CHAMPUS/CHAMPVA AMT 97";
label variable AMCOFD97 "CHIRO AMB VISITS -OTHER FEDERAL AMT 97";
label variable AMCSTL97 "CHIRO AMB VISITS -OTH ST/LOCAL AMT 97";
label variable AMCWCP97 "CHIRO AMB VISITS-WORKERS COMP AMT 97";
label variable AMCOPR97 "CHIRO AMB VISITS - OTH PRIVATE AMT 97";
label variable AMCOPU97 "CHIRO AMB VISITS - OTH PUBLIC AMT 97";
label variable AMCOSR97 "CHIR AMB VSTS - OTH UNCLASS SRCE AMT 97";
label variable AMNURS97 "# AMB NURSE/PRCTITIONR VSTS(OB+OP) 97";
label variable AMNTCH97 "NRS/PRAC AMBULATORY VISIT CHARGES 97";
label variable AMNEXP97 "TOTL AMBULTRY (OB+OP) NURSE/PRAC EXP 97";
label variable AMNSLF97 "NRS/PRAC AMB VSTS -SELF/FAMILY AMT 97";
label variable AMNMCR97 "NRS/PRAC AMB VSTS -MEDICARE AMT 97";
label variable AMNMCD97 "NRS/PRAC AMB VSTS -MEDICAID AMT 97";
label variable AMNPRV97 "NRS/PRAC AMB VSTS -PRIV INS AMT 97";
label variable AMNVA97 "NRS/PRAC AMB VSTS-VA AMT 97";
label variable AMNCHM97 "NRS/PRAC AMB VSTS-CHAMPUS/CHAMPVA AMT 97";
label variable AMNOFD97 "NRS/PRAC AMB VSTS-OTHER FEDERAL AMT 97";
label variable AMNSTL97 "NRS/PRAC AMB VSTS-OTH ST/LOCAL AMT 97";
label variable AMNWCP97 "NRS/PRAC AMB VSTS-WORKERS COMP AMT 97";
label variable AMNOPR97 "NRS/PRAC AMB VSTS - OTH PRIVATE AMT 97";
label variable AMNOPU97 "NRS/PRAC AMB VSTS - OTH PUBLIC AMT 97";
label variable AMNOSR97 "NRS/PR AMB VSTS - OTH UNCLAS SRCE AMT 97";
label variable AMOPTO97 "# AMB OPTOMETRIST VSTS (OB+OP) 97";
label variable AMETCH97 "OPTOMETRIST AMBULATORY VISIT CHARGES 97";
label variable AMEEXP97 "TOTL AMBULTRY (OB+OP) OPTOMETRIST EXP 97";
label variable AMESLF97 "OPTMTRIST AMB VSTS -SELF/FAMILY AMT 97";
label variable AMEMCR97 "OPTMTRIST AMB VSTS -MEDICARE AMT 97";
label variable AMEMCD97 "OPTMTRIST AMB VSTS -MEDICAID AMT 97";
label variable AMEPRV97 "OPTMTRIST AMB VSTS -PRIVATE INS AMT 97";
label variable AMEVA97 "OPTMTRIST AMB VSTS-VA AMT 97";
label variable AMECHM97 "OPTMTRIST AMB VSTS-CHMPUS/CHMPVA AMT 97";
label variable AMEOFD97 "OPTMTRIST AMB VSTS-OTHER FED AMT 97";
label variable AMESTL97 "OPTMTRIST AMB VSTS-OTH ST/LOCAL AMT 97";
label variable AMEWCP97 "OPTMTRIST AMB VSTS-WORKERS COMP AMT 97";
label variable AMEOPR97 "OPTMTRIST AMB VSTS - OTH PRIVATE AMT 97";
label variable AMEOPU97 "OPTMTRIST AMB VSTS - OTH PUBLIC AMT 97";
label variable AMEOSR97 "OPTOM AMB VSTS - OTH UNCLAS SRCE AMT 97";
label variable AMASST97 "# PHYSICIAN ASS T VSTS (OFF+OUPAT), 1997";
label variable AMATCH97 "PHYS ASS T AMBULATORY VISIT CHARGES 97";
label variable AMAEXP97 "TOTL AMBULTRY (OB+OP) PHYS ASS T EXP 97";
label variable AMASLF97 "PHYS ASS T AMB VSTS-SELF/FAMILY AMT 97";
label variable AMAMCR97 "PHYS ASS T AMB VSTS-MEDICARE AMT 97";
label variable AMAMCD97 "PHYS ASS T AMB VSTS-MEDICAID AMT 97";
label variable AMAPRV97 "PHYS ASS T AMB VSTS-PRIVATE INS AMT 97";
label variable AMAVA97 "PHYS ASS T AMB VSTS-VA AMT 97";
label variable AMACHM97 "PHYS ASS T AMB VSTS-CHMPUS/CHMPVA AMT 97";
label variable AMAOFD97 "PHYS ASS T AMB VSTS -OTHER FED AMT 97";
label variable AMASTL97 "PHYS ASS T AMB VSTS-OTH ST/LOCL AMT 97";
label variable AMAWCP97 "PHYS ASS T AMB VSTS-WRKERS COMP AMT 97";
label variable AMAOPR97 "PHYS ASS T AMB VSTS - OTH PRIVATE AMT 97";
label variable AMAOPU97 "PHYS ASS T AMB VSTS - OTH PUBLIC AMT 97";
label variable AMAOSR97 "P A AMB VSTS- OTH UNCLASS SRCE AMT 97";
label variable AMTHER97 "# AMB PT/OT THRPY VISITS (OB+OP) 97";
label variable AMTTCH97 "PT/OC AMBULATORY VISIT CHARGES 97";
label variable AMTEXP97 "TOTL AMBULTRY (OB+OP) PT/OT EXP 97";
label variable AMTSLF97 "PT/OT AMB VISITS-SELF/FAMILY AMT 97";
label variable AMTMCR97 "PT/OT AMB VISITS-MEDICARE AMT 97";
label variable AMTMCD97 "PT/OT AMB VISITS-MEDICAID AMT 97";
label variable AMTPRV97 "PT/OT AMB VISITS-PRIVATE INS AMT 97";
label variable AMTVA97 "PT/OT AMB VISITS-VA AMT 97";
label variable AMTCHM97 "PT/OT AMB VISITS-CHAMPUS/CHAMPVA AMT 97";
label variable AMTOFD97 "PT/OT AMB VISITS -OTHER FED AMT 97";
label variable AMTSTL97 "PT/OT AMB VISITS-OTH ST/LOCL AMT 97";
label variable AMTWCP97 "PT/OT AMB VISITS-WORKERS COMP AMT 97";
label variable AMTOPR97 "PT/OT AMB VISITS - OTH PRIVATE AMT 97";
label variable AMTOPU97 "PT/OT AMB VISITS-OTH PUBLIC AMT 97";
label variable AMTOSR97 "PT/OT AMB VSTS-OTH UNCLAS SRCE AMT 97";
label variable AMTOTC97 "# CALLS W/OFFICE & OUPAT DEPTS, 1997";
label variable AMDRC97 "# CALLS W/OFF & OUTPAT PHYSICIANS, 1997";
label variable ERTOT97 "# EMERGENCY ROOM VISITS 97";
label variable ERFTCH97 "ER FACILITY VISIT CHARGES 97";
label variable ERFEXP97 "TOTAL ER FACILITY EXP 97";
label variable ERFSLF97 "ER-SELF/FAMILY AMT - FAC 97";
label variable ERFMCR97 "ER-MEDICARE AMT - FAC 97";
label variable ERFMCD97 "ER-MEDICAID AMT - FAC 97";
label variable ERFPRV97 "ER-PRIVATE INS AMT - FAC 97";
label variable ERFVA97 "ER-VA AMT - FAC 97";
label variable ERFCHM97 "ER-CHAMPUS/CHAMPVA AMT - FAC 97";
label variable ERFOFD97 "ER-OTHER FEDERAL AMT - FAC 97";
label variable ERFSTL97 "ER-OTH ST/LOCAL AMT - FAC 97";
label variable ERFWCP97 "ER-WORKERS COMP AMT - FAC 97";
label variable ERFOPR97 "ER-OTHER PRIVATE AMT - FAC 97";
label variable ERFOPU97 "ER-OTHER PUBLIC AMT - FAC 97";
label variable ERFOSR97 "ER-OTH UNCLASS SRCE AMT - FAC 97";
label variable ERDEXP97 "TOTAL EMERGENCY ROOM DR EXP 97";
label variable ERDTCH97 "ER DOCTOR VISIT CHARGES 97";
label variable ERDSLF97 "ER-SELF/FAMILY AMT - DR 97";
label variable ERDMCR97 "ER-MEDICARE AMT - DR 97";
label variable ERDMCD97 "ER-MEDICAID AMT - DR 97";
label variable ERDPRV97 "ER-PRIVATE INS AMT - DR 97";
label variable ERDVA97 "ER-VA AMT - DR 97";
label variable ERDCHM97 "ER-CHAMPUS/CHAMPVA AMT - DR 97";
label variable ERDOFD97 "ER-OTHER FED AMT - DR 97";
label variable ERDSTL97 "ER-OTH ST/LOCAL AMT - DR 97";
label variable ERDWCP97 "ER-WORKERS COMP AMT - DR 97";
label variable ERDOPR97 "ER - OTHER PRIVATE AMT - DR 97";
label variable ERDOPU97 "ER - OTHER PUBLIC AMT - DR 97";
label variable ERDOSR97 "ER-OTH UNCLASS SRCE AMT - DR 97";
label variable IPZERO97 "# ZERO-NIGHT HOSPITAL STAYS 97";
label variable ZIFTCH97 "ZERO-NITE IP STAY CHARGES - FAC 97";
label variable ZIFEXP97 "TOTAL ZERO-NITE STAYS FAC EXP 97";
label variable ZIFSLF97 "ZERO-NITE IP STAZ -SELF/FAM AMT-FAC 97";
label variable ZIFMCR97 "ZERO-NITE IP STAZ-MEDICARE AMT-FAC 97";
label variable ZIFMCD97 "ZERO-NITE IP STAZ-MEDICAID AMT-FAC 97";
label variable ZIFPRV97 "ZERO-NITE IP STAZ-PRIV INS AMT-FAC 97";
label variable ZIFVA97 "ZERO-NITE IP STAZ-VA AMT-FAC 97";
label variable ZIFCHM97 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-FAC 97";
label variable ZIFOFD97 "ZERO-NITE IP STAZ-OTHER FED AMT-FAC 97";
label variable ZIFSTL97 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-FAC 97";
label variable ZIFWCP97 "ZERO-NITE IP STAZ-WRKERS COMP AMT-FAC 97";
label variable ZIFOPR97 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-FAC 97";
label variable ZIFOPU97 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-FAC 97";
label variable ZIFOSR97 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-FAC 97";
label variable ZIDEXP97 "TOTAL ZERO-NITE STAZ DR 97";
label variable ZIDTCH97 "ZERO-NITE IP STAY CHARGES - DR 97";
label variable ZIDSLF97 "ZERO-NITE IP STAZ-SELF/FAM AMT-DR 97";
label variable ZIDMCR97 "ZERO-NITE IP STAZ-MEDICARE AMT-DR 97";
label variable ZIDMCD97 "ZERO-NITE IP STAZ-MEDICAID AMT-DR 97";
label variable ZIDPRV97 "ZERO-NITE IP STAZ-PRIV INS AMT-DR 97";
label variable ZIDVA97 "ZERO-NITE IP STAZ-VA AMT-DR 97";
label variable ZIDCHM97 "ZERO-NITE IP STAZ-CHPUS/CHPVA AMT-DR 97";
label variable ZIDOFD97 "ZERO-NITE IP STAZ-OTHER FED AMT-DR 97";
label variable ZIDSTL97 "ZERO-NITE IP STAZ-OTH ST/LOC AMT-DR 97";
label variable ZIDWCP97 "ZERO-NITE IP STAZ-WRKERS COMP AMT-DR 97";
label variable ZIDOPR97 "ZERO-NITE IP STAZ-OTH PRIVATE AMT-DR 97";
label variable ZIDOPU97 "ZERO-NITE IP STAZ-OTH PUBLIC AMT-DR 97";
label variable ZIDOSR97 "ZERO-NITE IP STAZ-UNCLAS SRCE AMT-DR 97";
label variable IPDIS97 "# HOSPITAL DISCHARGES, 1997";
label variable IPFEXP97 "TOT HOSP IP FACILITY EXP-INC 0 NITES 97";
label variable IPFTCH97 "IP HOSP STAY CHARGES - FAC 97";
label variable IPFSLF97 "IP HOSP STAZ-SELF/FAMILY AMT-FAC 97";
label variable IPFMCR97 "IP HOSP STAZ-MEDICARE AMT-FAC 97";
label variable IPFMCD97 "IP HOSP STAZ-MEDICAID AMT-FAC 97";
label variable IPFPRV97 "IP HOSP STAZ-PRIV INS AMT-FAC 97";
label variable IPFVA97 "IP HOSP STAZ-VA AMT-FAC 97";
label variable IPFCHM97 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-FAC 97";
label variable IPFOFD97 "IP HOSP STAZ-OTHER FED AMT-FAC 97";
label variable IPFSTL97 "IP HOSP STAZ-OTH ST/LOCAL AMT-FAC 97";
label variable IPFWCP97 "IP HOSP STAZ-WORKERS COMP AMT-FAC 97";
label variable IPFOPR97 "IP HOSP STAZ - OTH PRIVATE AMT-FAC 97";
label variable IPFOPU97 "IP HOSP STAZ - OTH PUBLIC AMT-FAC 97";
label variable IPFOSR97 "IP HOSP STAZ-OT UNCLASS SRCE AMT-FAC 97";
label variable IPDEXP97 "TOTL HOSP STAZ DR EXP 97";
label variable IPDTCH97 "IP HOSP STAY CHARGES - DR 97";
label variable IPDSLF97 "IP HOSP STAZ-SELF/FAMILY AMT-DR 97";
label variable IPDMCR97 "IP HOSP STAZ-MEDICARE AMT- DR 97";
label variable IPDMCD97 "IP HOSP STAZ-MEDICAID AMT-DR 97";
label variable IPDPRV97 "IP HOSP STAZ-PRIV INS AMT- DR 97";
label variable IPDVA97 "IP HOSP STAZ-VA AMT-DR 97";
label variable IPDCHM97 "IP HOSP STAZ-CHAMPUS/CHAMPVA AMT-DR 97";
label variable IPDOFD97 "IP HOSP STAZ-OTHER FED AMT-DR 97";
label variable IPDSTL97 "IP HOSP STAZ-OTH ST/LOCAL AMT-DR 97";
label variable IPDWCP97 "IP HOSP STAZ-WORKERS COMP AMT-DR 97";
label variable IPDOPR97 "IP HOSP STAZ - OTH PRIVATE AMT-DR 97";
label variable IPDOPU97 "IP HOSP STAZ - OTH PUBLIC AMT-DR 97";
label variable IPDOSR97 "IP HOSP STAZ-OT UNCLASS SORCE AMT-DR 97";
label variable IPNGTD97 "# NIGHTS IN HOSP FOR DISCHARGES, 1997";
label variable DVTOT97 "# DENTAL CARE VISITS 97";
label variable DVTTCH97 "TOTAL DENTAL CARE VISIT CHARGES 97";
label variable DVTEXP97 "TOTAL DENTAL CARE EXP 97";
label variable DVTSLF97 "ALL DENTAL CARE -SELF/FAMILY AMT 97";
label variable DVTMCR97 "ALL DENTAL CARE -MEDICARE AMT 97";
label variable DVTMCD97 "ALL DENTAL CARE -MEDICAID AMT 97";
label variable DVTPRV97 "ALL DENTAL CARE -PRIVATE INS AMT 97";
label variable DVTVA97 "ALL DENTAL CARE-VA AMT 97";
label variable DVTCHM97 "ALL DENTAL CARE-CHAMPUS/CHAMPVA AMT 97";
label variable DVTOFD97 "ALL DENTAL CARE -OTHER FEDRL AMT 97";
label variable DVTSTL97 "ALL DENTAL CARE-OTH ST/LOCAL AMT 97";
label variable DVTWCP97 "ALL DENTAL CARE-WORKERS COMP AMT 97";
label variable DVTOPR97 "ALL DENTAL CARE - OTH PRIVATE AMT 97";
label variable DVTOPU97 "ALL DENTAL CARE - OTH PUBLIC AMT 97";
label variable DVTOSR97 "ALL DENT CARE-OT UNCLASS SRCE AMT 97";
label variable DVGEN97 "# GENERAL DENTIST VISITS 97";
label variable DVGTCH97 "GENERAL DENTAL CARE VISIT CHARGES 97";
label variable DVGEXP97 "TOTAL GENERAL DENTIST EXP 97";
label variable DVGSLF97 "GNRL DENTAL VISITS -SELF/FAM AMT 97";
label variable DVGMCR97 "GNRL DENTAL VISITS -MEDICARE AMT 97";
label variable DVGMCD97 "GNRL DENTAL VISITS -MEDICAID AMT 97";
label variable DVGPRV97 "GNRL DENTAL VISITS -PRIVATE INS AMT 97";
label variable DVGVA97 "GNRL DENTAL VISITS -VA AMT 97";
label variable DVGCHM97 "GNRL DENTAL VISITS-CHMPUS/CHMPVA AMT 97";
label variable DVGOFD97 "GNRL DENTAL VISITS- OTHER FED AMT 97";
label variable DVGSTL97 "GNRL DENTAL VISITS - OTH ST/LOCAL AMT 97";
label variable DVGWCP97 "GNRL DENTAL VISITS - WORKERS COMP AMT 97";
label variable DVGOPR97 "GNRL DENTAL VISITS - OTH PRIVATE AMT 97";
label variable DVGOPU97 "GNRL DENTAL VISITS - OTH PUBLIC AMT 97";
label variable DVGOSR97 "GNRL DENT VSTS - OT UNCLASS SRCE AMT 97";
label variable DVORTH97 "# ORTHODONTIST VISITS 97";
label variable DVOTCH97 "ORTHODONTIST VISIT CHARGES 97";
label variable DVOEXP97 "TOTAL ORTHODONTIST EXP 97";
label variable DVOSLF97 "ORTHODONTIST VISITS -SELF/FAMILY AMT 97";
label variable DVOMCR97 "ORTHODONTIST VISITS -MEDICARE AMT 97";
label variable DVOMCD97 "ORTHODONTIST VISITS -MEDICAID AMT 97";
label variable DVOPRV97 "ORTHODONTIST VISITS -PRIVATE INS AMT 97";
label variable DVOVA97 "ORTHODONTIST VISITS-VA AMT 97";
label variable DVOCHM97 "ORTHODONTIST VISITS-CHMPUS/CHMPVA AMT 97";
label variable DVOOFD97 "ORTHODONTIST VISITS-OTHR FED AMT 97";
label variable DVOSTL97 "ORTHODONTIST VISITS-OTHR ST/LOCAL AMT 97";
label variable DVOWCP97 "ORTHODONTIST VISITS-WORKERS COMP AMT 97";
label variable DVOOPR97 "ORTHODONTIST VISITS-OTHR PRIVATE AMT 97";
label variable DVOOPU97 "ORTHODONTIST VISITS-OTHR PUBLIC AMT 97";
label variable DVOOSR97 "ORTHODONT VSTS - OT UNCLASS SRCE AMT 97";
label variable HHTOTD97 "# HOME HEALTH PROVIDER DAYS, 1997";
label variable HHAGD97 "# AGENCY HOME HEALTH PROVIDER DAYS 97";
label variable HHATCH97 "HOME HEALTH AGENCY VISIT CHARGES 97";
label variable HHAEXP97 "TOTAL HOME HEALTH AGENCY EXP 97";
label variable HHASLF97 "HOME HLTH AGENCY -SELF/FAMILY AMT 97";
label variable HHAMCR97 "HOME HLTH AGENCY -MEDICARE AMT 97";
label variable HHAMCD97 "HOME HLTH AGENCY -MEDICAID AMT 97";
label variable HHAPRV97 "HOME HLTH AGENCY -PRIVATE INS AMT 97";
label variable HHAVA97 "HOME HLTH AGENCY-VA AMT 97";
label variable HHACHM97 "HOME HLTH AGENCY-CHAMPUS/CHAMPVA AMT 97";
label variable HHAOFD97 "HOME HLTH AGENCY-OTHER FED AMT 97";
label variable HHASTL97 "HOME HLTH AGENCY-OTHR ST/LOCAL AMT 97";
label variable HHAWCP97 "HOME HLTH AGENCY- WORKERS COMP AMT 97";
label variable HHAOPR97 "HOME HLTH AGENCY - OTH PRIVATE AMT 97";
label variable HHAOPU97 "HOME HLTH AGENCY - OTH PUBLIC AMT 97";
label variable HHAOSR97 "H HLTH AGENCY - OT UNCLASS SRCE AMT 97";
label variable HHINDD97 "# NON-AGENCY HOME HEALTH PROVIDR DAYS 97";
label variable HHNTCH97 "HOME HEALTH NON-AGENCY VISIT CHARGES 97";
label variable HHNEXP97 "TOTAL HOME HEALTH NON-AGNCY EXP 97";
label variable HHNSLF97 "HOME HLTH NON-AGNCY -SELF/FAM AMT 97";
label variable HHNMCR97 "HOME HLTH NON-AGNCY -MEDICARE AMT 97";
label variable HHNMCD97 "HOME HLTH NON-AGNCY -MEDICAID AMT 97";
label variable HHNPRV97 "HOME HLTH NON-AGNCY -PRIV INS AMT 97";
label variable HHNVA97 "HOME HLTH NON-AGNCY-VA AMT 97";
label variable HHNCHM97 "HOME HLTH NON-AGNCY-CHMPUS/CHMPVA AMT 97";
label variable HHNOFD97 "HOME HLTH NON-AGNCY-OTHR FED AMT 97";
label variable HHNSTL97 "HOME HLTH NON-AGNCY-OTHR ST/LOCL AMT 97";
label variable HHNWCP97 "HOME HLTH NON-AGNCY-WORKERS COMP AMT 97";
label variable HHNOPR97 "HOME HLTH NON-AGNCY-OTH PRIVATE AMT 97";
label variable HHNOPU97 "HOME HLTH NON-AGNCY-OTH PUBLIC AMT 97";
label variable HHNOSR97 "H HLTH NON-AGNCY-OT UNCLASS SRCE AMT 97";
label variable HHINFD97 "# INFORMAL HOME HEALTH PROVIDER DAYS 97";
label variable VISEXP97 "TOTAL GLASSES/CONTACT LENS EXP 97";
label variable VISTCH97 "GLASSES/CONTACT LENSES CHARGES 97";
label variable VISSLF97 "GLASSES/CNTCT LENSES -SELF/FAM AMT 97";
label variable VISMCR97 "GLASSES/CNTCT LENSES-MEDICARE AMT 97";
label variable VISMCD97 "GLASSES/CNTCT LENSES-MEDICAID AMT 97";
label variable VISPRV97 "GLASSES/CNTCT LENSES-PRIV INS AMT 97";
label variable VISVA97 "GLASSES/CNTCT LENSES-VA AMT 97";
label variable VISCHM97 "GLASSES/LENSES-CHAMPUS/CHAMPVA AMT 97";
label variable VISOFD97 "GLASSES/CNTCT LENSES-OTHR FED AMT 97";
label variable VISSTL97 "GLASSES/CNTCT LENSES-OTH ST/LOCL AMT 97";
label variable VISWCP97 "GLASSES/CNTCT LENSES-WORKERS COMP AMT 97";
label variable VISOPR97 "GLASSES/CNTCT LENSES-OTH PRIVATE AMT 97";
label variable VISOPU97 "GLASSES/CNTCT LENSES-OTH PUBLIC AMT 97";
label variable VISOSR97 "GLASES/CNTCT LENSE-OT UNCLAS SRCE AMT 97";
label variable OTHTCH97 "OTHER EQUP/SUPPLIES CHARGES 97";
label variable OTHEXP97 "TOT OTHER EQUIP/SPLY (EXCL DIAB) EXP 97";
label variable OTHSLF97 "OTHER EQUP/SUPPLIES -SELF/FAM AMT 97";
label variable OTHMCR97 "OTHER EQUP/SUPPLIES-MEDICARE AMT 97";
label variable OTHMCD97 "OTHER EQUP/SUPPLIES-MEDICAID AMT 97";
label variable OTHPRV97 "OTHER EQUP/SUPPLIES-PRIV INS AMT 97";
label variable OTHVA97 "OTHER EQUP/SUPPLY-VA AMT 97";
label variable OTHCHM97 "OTHER EQUP/SUPPLY-CHAMPUS/CHAMPVA AMT 97";
label variable OTHOFD97 "OTHER EQUP/SUPPLIES-OTHR FEDRL AMT 97";
label variable OTHSTL97 "OTHER EQUP/SUPPLY-OTHR ST/LOCAL AMT 97";
label variable OTHWCP97 "OTHER EQUP/SUPPLY -WORKERS COMP AMT 97";
label variable OTHOPR97 "OTHER EQUP/SUPPLY-OTH PRIVATE AMT 97";
label variable OTHOPU97 "OTHER EQUP/SUPPLY -OTH PUBLIC AMT 97";
label variable OTHOSR97 "OTH EQUP/SUPLY -OT UNCLASS SRCE AMT 97";
label variable RXTOT97 "# PRESC MEDS INCL REFILLS 97";
label variable RXEXP97 "TOTAL RX-EXP 97";
label variable RXSLF97 "TOTAL RX-SELF/FAMILY AMT 97";
label variable RXMCR97 "TOTAL RX--MEDICARE AMT 97";
label variable RXMCD97 "TOTAL RX-MEDICAID AMT 97";
label variable RXPRV97 "TOTAL RX-PRIVATE INS AMT 97";
label variable RXVA97 "TOTAL RX-VA AMT 97";
label variable RXCHM97 "TOTAL RX-CHAMPUS/CHAMPVA AMT 97";
label variable RXOFD97 "TOTAL RX-OTHER FED AMT 97";
label variable RXSTL97 "TOTAL RX-OTHER ST/LOCAL AMT 97";
label variable RXWCP97 "TOTAL RX-WORKERS COMP AMT 97";
label variable RXOPR97 "TOTAL RX - OTH PRIVATE AMT 97";
label variable RXOPU97 "TOTAL RX - OTH PUBLIC AMT 97";
label variable RXOSR97 "TOT RX-OTH UNCLASS SRCE AMT 97";
label variable WTDPER97 "POVERTY/MORTALITY ADJUSTED PERS LEVL WGT";
label variable WTFAMF97 "POVERTY ADJUSTED FAMILY WEIGHT";
label variable WTCFAM97 "POV ADJ FAMILY WGT-CPS FAM ON 12/31/97";
label variable VARSTR97 "VARIANCE ESTIMATION STRATUM - 1997";
label variable VARPSU97 "VARIANCE ESTIMATION PSU - 1997";


*DEFINE VALUE LABELS FOR REPORTS;
label define H200001X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H200002X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H200003X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - ACTIVE DUTY"
         2 "2 NO - NOT FT ACTIVE DUTY"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 OVER 59 - INAPPLICABLE" ;

label define H200004X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 CODED INAPPLICABLE BY QUESTION" ;

label define H200010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200011X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200012X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200013X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200014X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200015X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200016X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200017X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200018X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200019X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200020X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         37 "$37 - $37" ;

label define H200021X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200022X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200023X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200024X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200025X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         93 "$93 - $93" ;

label define H200026X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200027X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200028X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200029X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200030X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200031X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200032X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200033X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200034X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200035X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200036X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         197 "$197 - $197" ;

label define H200037X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200038X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200039X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200040X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200041X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200042X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18 - $18" ;

label define H200043X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200044X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200045X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200046X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200047X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200048X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200049X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         20 "$20 - $20" ;

label define H200050X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200051X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         73 "$73 - $73" ;

label define H200052X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200053X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200054X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200055X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200056X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200057X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200058X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         48 "$48 - $48" ;

label define H200059X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200060X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200061X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200062X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200063X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200064X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200065X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200067X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200081X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200082X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200083X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200084X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200085X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200086X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200087X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         400 "$400 - $400" ;

label define H200088X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200089X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200090X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200091X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200092X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200093X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200094X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200095X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200096X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200097X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200098X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1996 "1996 YEAR"
         1997 "1997 YEAR" ;

label define H200099X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR" ;

label define H200100X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR"
         1998 "1998 YEAR" ;

label define H200101X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200102X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200103X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE VARIES" ;

label define H200104X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE VARIES" ;

label define H200105X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE VARIES" ;

label define H200106X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200107X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H200108X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H200109X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 INCORPORATED"
         2 "2 PROPRIETORSHIP"
         3 "3 PARTNERSHIP" ;

label define H200110X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200111X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200112X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LIMITED IN ATTENDANCE"
         2 "2 UNABLE TO ATTEND"
         3 "3 NEITHER" ;

label define H200113X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200114X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200115X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200116X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200117X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H200118X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LEFT PREVIOUS CMJ/HAS CMJ"
         2 "2 CHANGED CURRENT MAIN JOB"
         3 "3 LEFT PREVIOUS CMJ/DOES NOT HAVE CMJ"
         4 "4 PREVIOUS CMJ CONTINUES; NO JOB CHANGE" ;

label define H200119X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200120X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200121X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200122X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200123X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200124X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200125X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200126X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200127X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200129X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200130X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200131X
         1 "1 YES"
         2 "2 NO" ;

label define H200132X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200133X
         -1 "-1 NOT ASCERTAINED"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 INDUSTRY UNKNOWN"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H200134X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 INDUSTRY UNKNOWN"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORATION/COMMUNICATION/UTILITES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H200135X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AGRICULTURE, FORESTRY, FISHERIES"
         10 "10 ENTERTAINMENT AND RECREATION"
         11 "11 PROFESSIONAL SERVICES"
         12 "12 PUBLIC ADMINISTRATION"
         13 "13 INDUSTRY UNKNOWN"
         14 "14 ACTIVE MILITARY"
         2 "2 MINING"
         3 "3 CONSTRUCTION"
         4 "4 MANUFACTURING"
         5 "5 TRANSPORTATION/COMMUNICATION/UTILITIES"
         6 "6 SALES"
         7 "7 FINANCE, INSURANCE, REAL ESTATE"
         8 "8 REPAIR SERVICES"
         9 "9 PERSONAL SERVICES" ;

label define H200136X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200137X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H200138X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNKNOWN"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H200139X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNKNOWN"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H200140X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PROFESSIONAL, TECHNICAL AND KINDRED"
         10 "10 FARM OWNERS AND MANAGERS"
         11 "11 FARM LABORERS AND FOREMEN"
         12 "12 UNKNOWN"
         13 "13 ACTIVE MILITARY"
         14 "14 LAST WORKED PRIOR TO 1984"
         2 "2 MANAGERIAL AND ADMINISTRATIVE"
         3 "3 SALES WORKERS"
         4 "4 CLERICAL AND KINDRED WORKERS"
         5 "5 CRAFTSMEN AND FOREMEN"
         6 "6 OPERATIVES"
         7 "7 TRANSPORT OPERATIVES"
         8 "8 SERVICE WORKERS"
         9 "9 LABORERS, NOT FARMING" ;

label define H200141X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200142X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200143X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200144X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H200145X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200146X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ITEMIZED DEDUCTIONS"
         2 "2 STANDARD DEDUCTIONS" ;

label define H200147X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200148X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NOW ACTIVE DUTY" ;

label define H200149X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE-CM JOB" ;

label define H200150X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE-CM JOB" ;

label define H200151X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISAVOWS INSURANCE THROUGH CMJ"
         2 "2 DOES NOT DISAVOW INSURANCE" ;

label define H200152X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200153X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200154X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200155X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEPS IN RU"
         2 "2 DEPS IN AND OUT OF RU"
         3 "3 DEPS OUT OF RU" ;

label define H200156X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 DEPENDENTS OUTSIDE RU"
         1 "1 ONE DEPENDENT OUTSDIE RU"
         2 "2 TWO DEPENDENTS OUTSIDE RU"
         3 "3 THREE DEPENDENTS OUTSIDE RU" ;

label define H200157X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200158X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200159X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200160X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200161X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200162X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200163X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200164X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200165X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200166X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200167X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200168X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200169X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200170X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200171X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200172X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200173X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         68 "$68 - $68" ;

label define H200174X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200175X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200176X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200177X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1682 "$1682 - $1682" ;

label define H200178X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200179X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200180X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200181X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200182X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200183X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200184X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         127 "$127 - $127"
         534 "$535 - $534" ;

label define H200185X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200186X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         88 "$88 - $88" ;

label define H200187X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         120 "$120 - $120" ;

label define H200188X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200189X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200190X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200191X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200192X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200193X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200194X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200195X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200196X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200197X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200198X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200199X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200200X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200201X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200202X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200203X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H200204X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H200205X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H200206X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NEVER ATTENDED SCHOOL/KINDERGARTEN"
         12 "12 GRADE 12"
         13 "13 1 YEAR COLLEGE"
         14 "14 2 YEARS COLLEGE"
         15 "15 3 YEARS COLLEGE"
         16 "16 4 YEARS COLLEGE"
         17 "17 5+ YEARS COLLEGE" ;

label define H200207X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H200208X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO"
         3 "3 NOT APPLICABLE" ;

label define H200209X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H200210X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H200211X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H200212X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 PERSON IS IN NON-RESPONDING RU"
         3 "3 PERSON IS NOT ELIGIBLE"
         4 "4 PERSON IS NOT IN AN RU" ;

label define H200213X
         1 "1 PERSON IS ELIGIBLE"
         2 "2 NOT ELIG/NOT LINKED TO RESPONDING RU" ;

label define H200214X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 3/1 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 3/1 INT DATE"
         3 "3 JOB DURING RD 3/1 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 3/1" ;

label define H200215X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT DETERMINED"
         1 "1 EMPLOYED AT RD 4/2 INT DATE"
         2 "2 JOB TO RETURN AT RD 4/2 INT DATE"
         3 "3 JOB DURING RD 4/2 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 4/2" ;

label define H200216X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EMPLOYED AT RD 5/3 INT DATE"
         2 "2 JOB TO RETURN TO AT RD 5/3 INT DATE"
         3 "3 JOB DURING RD 5/3 REF PERIOD"
         4 "4 NOT EMPLOYED DURING RD 5/3" ;

label define H200217X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200218X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200219X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200220X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200221X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200222X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200223X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200224X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H200225X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR" ;

label define H200226X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR" ;

label define H200227X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200228X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1997 "1997 YEAR" ;

label define H200229X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE VARIES" ;

label define H200230X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE VARIES" ;

label define H200231X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         95 "95 SCHEDULE VARIES" ;

label define H200232X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200233X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200234X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200235X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200236X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18 - $18" ;

label define H200237X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200238X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200239X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         28 "$28 - $28"
         394 "$395 - $394" ;

label define H200240X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200241X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200242X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         7 "$7 - $7" ;

label define H200243X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200244X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18 - $18" ;

label define H200245X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200246X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200247X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200248X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200249X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200250X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200251X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200252X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200253X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200254X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200255X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200256X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200257X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200258X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200259X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200260X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200261X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200262X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200263X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200264X
         -1 "-1 INAPPLICABLE"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H200265X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H200266X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H200267X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H200268X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON"
         10 "10 PERSONS"
         11 "11 PERSONS"
         12 "12 PERSONS"
         13 "13 PERSONS"
         14 "14 PERSONS"
         2 "2 PERSONS"
         3 "3 PERSONS"
         4 "4 PERSONS"
         5 "5 PERSONS"
         6 "6 PERSONS"
         7 "7 PERSONS"
         8 "8 PERSONS"
         9 "9 PERSONS" ;

label define H200269X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200270X
         -1 "-1 INAPP, NOT MEM OF 12/31 FAMILY"
         0 "0 NOT A REFERENCE PERSON"
         1 "1 REFERENCE PERSON" ;

label define H200271X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200272X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIMARY FILER"
         2 "2 SECONDARY FILER" ;

label define H200273X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SINGLE"
         2 "2 MARRIED FILING JOINT RETURN"
         3 "3 MARRIED FILING SEPARATELY"
         4 "4 HEAD OF HOUSEHOLD W/QUALIFYING PERSON"
         5 "5 QUALIFYING WIDOWER W/DEPENDT" ;

label define H200274X
         -1 "-1 INAPPLICABLE"
         0 "0 NONRESPONDING 12/31 FAMILY"
         1 "1 RESPONDING 12/31 FAMILY" ;

label define H200275X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICUTLY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200276X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200277X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H200278X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         12 "12 FULL YEAR" ;

label define H200279X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200280X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H200281X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H200282X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H200283X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H200284X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 FULL-TIME"
         2 "2 PART-TIME"
         3 "3 NOT A STUDENT" ;

label define H200285X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NO FY FAM WEIGHT & NO PERS LEVL WEIGHT"
         1 "1 FY RESP FAM PRESENT ON 12-31-97, K/I"
         2 "2 FY RESP FAM NOT PRESENT 12-31-97, K/I"
         3 "3 FY R FAM NOT PRESNT 123197,NO K/I 1231"
         4 "4 NO FY RESP FAM WGT/HAS PERSON LEVL WGT" ;

label define H200286X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H200287X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H200288X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200289X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200290X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200291X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SLIGHT IMPAIRMENT"
         3 "3 MODERATE IMPAIRMENT"
         4 "4 MAJOR IMPAIRMENT"
         5 "5 DEAF" ;

label define H200292X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200293X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200294X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200295X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200296X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200297X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200298X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200299X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200300X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200301X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200302X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200303X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200304X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200305X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200306X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200307X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200308X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200309X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200310X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200311X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200312X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         19 "$19 - $19" ;

label define H200313X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         595 "$595 - $595" ;

label define H200314X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200315X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200316X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200317X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200318X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200319X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200320X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200321X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         50 "$50 - $50" ;

label define H200322X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200323X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         24 "$24 - $24" ;

label define H200324X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200325X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200326X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200327X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200328X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200329X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         80 "$80 - $80" ;

label define H200330X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200331X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H200332X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H200333X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H200334X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DEGREE"
         2 "2 GED"
         3 "3 HIGH SCHOOL DIPLOMA"
         4 "4 BACHELOR'S DEGREE"
         5 "5 MASTER'S DEGREE"
         6 "6 DOCTORATE DEGREE"
         7 "7 OTHER DEGREE"
         8 "8 UNDER 16 - INAPPLICABLE" ;

label define H200335X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 HISPANIC"
         2 "2 NOT HISPANIC" ;

label define H200336X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PUERTO RICAN"
         2 "2 CUBAN"
         3 "3 MEXICAN/MEXICAN AMERI/MEXICANO/CHICANO"
         4 "4 OTHER LATIN AMERICAN/OTHER SPANISH"
         5 "5 NON-HISPANIC" ;

label define H200337X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H200338X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H200339X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200340X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200341X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200342X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200343X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200344X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200345X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200346X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200347X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200348X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200349X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200350X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200351X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200352X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200353X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200354X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200355X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200356X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200357X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200358X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200359X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200360X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200361X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200362X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200363X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200364X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200365X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200366X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200367X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200368X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200369X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200370X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200371X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200372X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200373X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200374X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200375X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200376X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200377X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200378X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200379X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200380X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200381X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200382X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200383X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200384X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200385X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200386X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200387X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200388X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200389X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200390X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200391X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200392X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200393X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200394X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200395X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200396X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200397X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200398X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200399X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200400X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200401X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200402X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200403X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200404X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200405X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200406X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200407X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200408X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200409X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200410X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200411X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200412X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200413X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200414X
         -1 "-1 INAPPLICABLE"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE PROVIDED"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H200415X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -9 "-9 UNKNOWN (NOT IMPUTED)"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H200416X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -9 "-9 NOT ASCERTAINED"
         1 "1 IMPUTED USING RANGE ESTIMATE"
         2 "2 IMPUTED WITHOUT RANGE ESTIMATE"
         3 "3 NO CALCULATION: HOURLY WAGE"
         4 "4 CALCULATED FROM SALARY"
         5 "5 CALCULATED FROM PAID BY DAY"
         6 "6 CALCULATED FROM PIECEWORK/JOB/MILE"
         7 "7 CALCULATED FROM COMMISSIONS"
         8 "8 CALCULATED FROM BONUS" ;

label define H200417X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $43.75"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200418X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $43.75"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200419X
         -1 "-1 INAPPLICABLE"
         -10 "-10 HOURLY WAGE >= $43.75"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200420X
         0 "0 NO"
         1 "1 YES" ;

label define H200421X
         0 "0 NO"
         1 "1 YES" ;

label define H200422X
         0 "0 NO"
         1 "1 YES" ;

label define H200423X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200424X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200425X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200426X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200427X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200428X
         0 "0 NON-RESPONSE"
         1 "1 YES"
         2 "2 NO" ;

label define H200429X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200430X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200431X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 NOT IN-SCOPE - NOT RESP/NOT IN AN RU"
         1 "1 IN-SCOPE ON 12/31/1997"
         2 "2 NOT IN-SCOPE ON 12/31/1997" ;

label define H200432X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/97"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H200433X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/97"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H200434X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/97"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE (NOT IN RU) DURING ROUND"
         7 "7 NOT IN RU DURING ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H200435X
         0 "0 INCOR LISTED/OUT-OF-SCOPE PRIOR 1/1/97"
         1 "1 INSCOPE FOR WHOLE REFERENCE PERIOD"
         2 "2 INSCOPE AT START OF REF PER, NOT END"
         3 "3 NOT INSCOPE STRT REF PER, INSCOPE END"
         4 "4 INSCOPE REF PER, BUT NOT START NOR END"
         5 "5 MEM OF RU BUT OUT-OF-SCOPE ALL REF PER"
         6 "6 OUT-OF-SCOPE IN RU DURING THIS ROUND"
         7 "7 NOT IN RU, JOINED IN LATER ROUND"
         8 "8 RU NON-RESPONSE"
         9 "9 NON-KEY, NOT IN RU, PREVIOUS RU MEMBER" ;

label define H200436X
         0 "0 NOT RECORDED AS BEING INSCOPE"
         1 "1 INSCOPE AT SOME TIME DURING 1997"
         2 "2 OUT-OF-SCOPE FOR ALL OF 1997" ;

label define H200437X
         1 "1 ANY PRIVATE"
         2 "2 PUBLIC ONLY"
         3 "3 UNINSURED" ;

label define H200438X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200439X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200440X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200441X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200442X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200443X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200444X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200445X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200446X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200447X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200448X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200449X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200450X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200451X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200452X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200453X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200454X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200455X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200456X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200457X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200458X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         197 "$197 - $197" ;

label define H200459X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200460X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200461X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200462X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200463X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200464X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200465X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200466X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200467X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200468X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200469X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200470X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200471X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200472X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200473X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200474X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200475X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         760 "$760 - $760" ;

label define H200476X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200477X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200478X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200479X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200480X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200481X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200482X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200483X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200484X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200485X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H200486X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H200487X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PRIVATE COMPANY OR FOREIGN GOVT"
         2 "2 FEDERAL GOVT OR ARMED FORCES"
         3 "3 STATE OR LOCAL GOVT" ;

label define H200488X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200489X
         -1 "-1 INAPPLICABLE"
         1 "1 KEY"
         2 "2 NOT KEY" ;

label define H200490X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H200491X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200492X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200493X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200494X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200495X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200496X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED IN ROUND"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED IN ROUND"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H200497X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H200498X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         10 "10 SEPARATED IN ROUND"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE"
         7 "7 MARRIED IN ROUND"
         8 "8 WIDOWED IN ROUND"
         9 "9 DIVORCED IN ROUND" ;

label define H200499X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MARRIED"
         2 "2 WIDOWED"
         3 "3 DIVORCED"
         4 "4 SEPARATED"
         5 "5 NEVER MARRIED"
         6 "6 UNDER 16 - INAPPLICABLE" ;

label define H200500X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200501X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200502X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200503X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200504X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200505X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200506X
         1 "1 YES"
         2 "2 NO" ;

label define H200507X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200508X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200509X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200510X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200511X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200512X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200513X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200514X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200515X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200516X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200517X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200518X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200519X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200520X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200521X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200522X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200523X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200524X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200525X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200526X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200527X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200528X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200529X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200530X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200531X
         1 "1 YES"
         2 "2 NO" ;

label define H200532X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200533X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200534X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200535X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200536X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200537X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200538X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200539X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200540X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200541X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200542X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200543X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200544X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200545X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200546X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200547X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200548X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200549X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200550X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H200551X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200552X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200553X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200554X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H200555X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H200556X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H200557X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H200558X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H200559X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H200560X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H200561X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200562X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200563X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200564X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H200565X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H200566X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MORE THAN ONE CURRENT JOB"
         2 "2 NOT MORE THAN ONE CURRENT JOB" ;

label define H200567X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H200568X
         -1 "-1 INAPPLICABLE"
         0 "0 NON-MSA"
         1 "1 MSA" ;

label define H200569X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H200570X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DEFINITELY FALSE"
         2 "2 MOSTLY FALSE"
         3 "3 MOSTLY TRUE"
         4 "4 DEFINITELY TRUE" ;

label define H200571X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H200572X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H200573X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200574X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200575X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H200576X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ONCE"
         2 "2 SEVERAL TIMES" ;

label define H200577X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H200578X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H200579X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 COULD NOT FIND WORK"
         2 "2 RETIRED"
         3 "3 UNABLE TO WORK BECAUSE ILL/DISABLED"
         4 "4 ON TEMPORARY LAYOFF"
         5 "5 MATERNITY/PATERNITY LEAVE"
         6 "6 GOING TO SCHOOL"
         7 "7 TAKING CARE OF HOME OR FAMILY"
         8 "8 WANTED SOME TIME OFF"
         9 "9 WAITING TO START NEW JOB"
         91 "91 OTHER" ;

label define H200580X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200581X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200582X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200583X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200584X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200585X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200586X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         37 "$37 - $37" ;

label define H200587X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200588X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200589X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200590X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200591X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         93 "$93 - $93" ;

label define H200592X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200593X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200594X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200595X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200596X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200597X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200598X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200599X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200600X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200601X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200602X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         197 "$197 - $197" ;

label define H200603X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200604X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200605X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200606X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200607X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200608X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18 - $18" ;

label define H200609X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200610X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200611X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200612X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200613X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200614X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200615X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200616X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200617X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200618X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200619X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200620X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200621X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200622X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200623X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200624X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200625X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200626X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200627X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200628X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200629X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         20 "$20 - $20"
         209 "$210 - $209" ;

label define H200630X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200631X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         76 "$76 - $76" ;

label define H200632X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200633X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200634X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200635X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200636X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200637X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200638X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         134 "$135 - $134"
         48 "$48 - $48" ;

label define H200639X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200640X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200641X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200642X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200643X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200644X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200645X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200646X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200647X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200648X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200649X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200650X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200651X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200652X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200653X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200654X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200655X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200656X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200657X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200658X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200659X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200660X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200661X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200662X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200663X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200664X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200665X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200666X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200667X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200668X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200669X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200670X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200671X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200672X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200673X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200674X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200675X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200676X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200677X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6 "$6 - $6" ;

label define H200678X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200679X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200680X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200681X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200682X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         422 "$422 - $422"
         660 "$661 - $660" ;

label define H200683X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200684X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200685X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200686X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200687X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200688X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200689X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200690X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200691X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200692X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200693X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200694X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200695X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200696X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200697X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200698X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200699X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200700X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200701X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200702X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200703X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200704X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200705X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200706X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200707X
         1 "1 YES"
         2 "2 NO" ;

label define H200708X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200709X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200710X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200711X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200712X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200713X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200714X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200715X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200716X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200717X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200718X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200719X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200720X
         1 "1 YES"
         2 "2 NO" ;

label define H200721X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200722X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200723X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200724X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200725X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200726X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200727X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200728X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200729X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200730X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200731X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200732X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200733X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200734X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200735X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200736X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200737X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200738X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200739X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "$1 - $1" ;

label define H200740X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200741X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         7 "$7 - $7" ;

label define H200742X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200743X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200744X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200745X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200746X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200747X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200748X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200749X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200750X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200751X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200752X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200753X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200754X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200755X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200756X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200757X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200758X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200759X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200760X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200761X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200762X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200763X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200764X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200765X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200766X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200767X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200768X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200769X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200770X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200771X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200772X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200773X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200774X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         12 "$12 - $12" ;

label define H200775X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200776X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200777X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200778X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200779X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200780X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200781X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200782X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200783X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200784X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         7 "$7 - $7" ;

label define H200785X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200786X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         50 "$50 - $50" ;

label define H200787X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200788X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200789X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200790X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200791X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200792X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200793X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200794X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200795X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200796X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200797X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200798X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         7 "$7 - $7" ;

label define H200799X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200800X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200801X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200802X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         1 "$1 - $1" ;

label define H200803X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200804X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200805X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200806X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200807X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200808X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200809X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200810X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200811X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200812X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200813X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200814X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200815X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200816X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200817X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200818X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200819X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200820X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200821X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200822X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16 - $16"
         600 "$601 - $600" ;

label define H200823X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200824X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         16 "$16 - $16" ;

label define H200825X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200826X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200827X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200828X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         6000 "$6001 - $6000"
         700 "$700 - $700" ;

label define H200829X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200830X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200831X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200832X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200833X
         1 "1 PANEL 1"
         2 "2 PANEL 2" ;

label define H200834X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200835X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200836X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200837X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200838X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200839X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200840X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200841X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200842X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200843X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200844X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200845X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200846X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200847X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200848X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200849X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200850X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200851X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200852X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200853X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200854X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200855X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200856X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200857X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200858X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200859X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200860X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200861X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200862X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200863X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200864X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200865X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200866X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200867X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200868X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200869X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200870X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200871X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200872X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200873X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200874X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200875X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200876X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200877X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200878X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200879X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200880X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200881X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200882X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200883X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200884X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200885X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200886X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200887X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200888X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200889X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200890X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200891X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200892X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200893X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200894X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200895X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200896X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200897X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200898X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200899X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200900X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200901X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200902X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200903X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200904X
         -1 "-1 INAPPLICABLE"
         1 "1 NEGATIVE OR POOR"
         2 "2 NEAR POOR"
         3 "3 LOW INCOME"
         4 "4 MIDDLE INCOME"
         5 "5 HIGH INCOME" ;

label define H200905X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200906X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200907X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200908X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200909X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200910X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200911X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200912X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200913X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200914X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200915X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200916X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200917X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H200918X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H200919X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H200920X
         -1 "-1 NON-RESPONSE"
         1 "1 RESPONDENT IS RU MEMBER"
         2 "2 RESPONDENT IS A PROXY" ;

label define H200921X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200922X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200923X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200924X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200925X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200926X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200927X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200928X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200929X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200930X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200931X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200932X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200933X
         1 "1 YES"
         2 "2 NO" ;

label define H200934X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 MOVED, FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE-R2 & R3 ONLY"
         22 "22 LEAVE INSTITUTION-R2 & R3 ONLY"
         23 "23 LEAVES INSTITUTION & DIES-R2 & 3 ONLY"
         24 "24 DIES IN INST DURING RD-R2 & R3 ONLY"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO A, W/OUT KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H200935X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 MOVED, FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE-R2 & R3 ONLY"
         22 "22 LEAVE INSTITUTION-R2 & R3 ONLY"
         23 "23 LEAVES INSTITUTION & DIES-R2 & 3 ONLY"
         24 "24 DIES IN INST DURING RD-R2 & R3 ONLY"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO A, W/OUT KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H200936X
         -1 "-1 NOT FIELDED/NON-RESPONSE RU"
         0 "0 INCORRECTLY LISTED IN RU AT NHIS"
         11 "11 PERSON IN HOUSEHLD, NOT FT ACTIVE MIL"
         12 "12 IN HOUSEHLD, FT MIL DUTY-OUT-SCOPE"
         13 "13 MOVED, FT STUD LIVING AWAY FROM HOME"
         14 "14 IN ORIG HH, FT ACTIVE DUTY-INSCOPE"
         21 "21 INSTITUTIONALIZED WHOLE-R2 & R3 ONLY"
         22 "22 LEAVE INSTITUTION-R2 & R3 ONLY"
         23 "23 LEAVES INSTITUTION & DIES-R2 & 3 ONLY"
         24 "24 DIES IN INST DURING RD-R2 & R3 ONLY"
         31 "31 DECEASED"
         32 "32 INSTITUTIONALIZED IN HEALTH CARE FAC"
         33 "33 INSTITUTIONALIZED NON-HEALTH CARE FAC"
         34 "34 MOVED OUTSIDE U.S., NOT AS STUDENT"
         35 "35 MOVED, FT ACTIVE DUTY"
         36 "36 INSTITUTIONALIZED (TYPE UNKNOWN)"
         41 "41 MOVED WITHIN U.S."
         42 "42 PERSON WHO JOINED RU, NOT FT MIL"
         43 "43 REASON UNK OR MOVED TO UNK LOCATION"
         44 "44 JOINS ANOTHER RU, & IS INSCOPE"
         51 "51 NEWBORN IN REF PERIOD"
         61 "61 DECEASED PRIOR TO REF PERIOD-R1 ONLY"
         62 "62 INSTITUT PRIOR TO REF PER-R1 ONLY"
         63 "63 LEFT U.S. PRIOR TO REF PER-R1 ONLY"
         64 "64 FT MIL, MIL FAC MOVE PRIOR REF PER-R1"
         71 "71 LIVING AWAY GRADES 1-12 NONKEY"
         72 "72 INELIG NON-KEY/RESIDENCY SCHL YR ONLY"
         73 "73 NONKEY, NOT FT MIL, MOVED W/OUT KEY"
         74 "74 MOVED AS FT MIL, NOT TO A, W/OUT KEY"
         81 "81 MOVED, FT STUD, NO RESP, DATA IMPUTED" ;

label define H200937X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200938X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200939X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200940X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200941X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200942X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200943X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200944X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200945X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200946X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200947X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200948X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200949X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200950X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H200951X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 PERSON IS HISPANIC"
         2 "2 PERSON IS BLACK/NOT HISPANIC"
         3 "3 OTHER" ;

label define H200952X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 AMERICAN INDIAN"
         2 "2 ALEUT, ESKIMO"
         3 "3 ASIAN OR PACIFIC ISLANDER"
         4 "4 BLACK"
         5 "5 WHITE"
         91 "91 OTHER" ;

label define H200953X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200954X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H200955X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200956X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200957X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200958X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H200959X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H200960X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H200961X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H200962X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H200963X
         -1 "-1 INAPPLICABLE"
         1 "1 NORTHEAST"
         2 "2 MIDWEST"
         3 "3 SOUTH"
         4 "4 WEST" ;

label define H200964X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H200965X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H200966X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H200967X
         0 "0 NON-RESPONSE"
         1 "1 YES, FIRST RESPONDENT"
         2 "2 NO, NOT FIRST RESPONDENT"
         3 "3 NOT DETERMINED" ;

label define H200968X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200969X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200970X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H200971X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H200972X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H200973X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         43 "43 FOSTER MOTHER"
         44 "44 FOSTER FATHER"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H200974X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0 SELF"
         1 "1 MOTHER"
         10 "10 FATHER-IN-LAW"
         11 "11 SISTER-IN-LAW"
         12 "12 BROTHER-IN-LAW"
         13 "13 DAUGHTER-IN-LAW"
         14 "14 SON-IN-LAW"
         15 "15 STEPMOTHER"
         16 "16 STEPFATHER"
         17 "17 STEPDAUGHTER"
         18 "18 STEPSON"
         19 "19 GRANDMOTHER"
         2 "2 FATHER"
         20 "20 GRANDFATHER"
         21 "21 AUNT"
         22 "22 UNCLE"
         23 "23 NIECE"
         24 "24 NEPHEW"
         25 "25 COUSIN"
         26 "26 GRANDSON"
         27 "27 GRANDDAUGHTER"
         28 "28 FEMALE PARTNER"
         29 "29 MALE PARTNER"
         3 "3 SISTER/STEP/HALF"
         30 "30 MOTHER'S PARTNER"
         31 "31 FATHER'S PARTNER"
         32 "32 DAUGHTER OF PARTNER"
         33 "33 SON OF PARTNER"
         34 "34 FOSTER CHILD"
         35 "35 GREAT GRANDMOTHER"
         36 "36 GREAT GRANDFATHER"
         37 "37 GREAT GRANDDAUGHTER"
         38 "38 GREAT GRANDSON"
         39 "39 GREAT AUNT"
         4 "4 BROTHER/STEP/HALF"
         40 "40 GREAT UNCLE"
         41 "41 GREAT NIECE"
         42 "42 GREAT NEPHEW"
         45 "45 FOSTER DAUGHTER"
         46 "46 FOSTER SON"
         5 "5 DAUGHTER/ADOPTED DAUGHTER"
         6 "6 SON/ADOPTED SON"
         7 "7 WIFE/SPOUSE"
         8 "8 HUSBAND/SPOUSE"
         9 "9 MOTHER-IN-LAW"
         91 "91 OTHER RELATED, SPECIFY"
         99 "99 NOT RELATED" ;

label define H200975X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 ROUND 1"
         2 "2 ROUND 2"
         3 "3 ROUND 3" ;

label define H200976X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H200977X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H200978X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 EXCELLENT"
         2 "2 VERY GOOD"
         3 "3 GOOD"
         4 "4 FAIR"
         5 "5 POOR" ;

label define H200979X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H200980X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H200981X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SELF"
         2 "2 PROXY" ;

label define H200982X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H200983X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H200984X
         -1 "-1 INAPPLICABLE"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H200985X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 STANDARD RU"
         2 "2 NEW RU"
         3 "3 STUDENT RU" ;

label define H200986X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H200987X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H200988X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H200989X
         -1 "-1 INAPPLICABLE"
         1 "1 PERSON IN RU"
         10 "10 PERSONS IN RU"
         11 "11 PERSONS IN RU"
         12 "12 PERSONS IN RU"
         13 "13 PERSONS IN RU"
         14 "14 PERSONS IN RU"
         2 "2 PERSONS IN RU"
         3 "3 PERSONS IN RU"
         4 "4 PERSONS IN RU"
         5 "5 PERSONS IN RU"
         6 "6 PERSONS IN RU"
         7 "7 PERSONS IN RU"
         8 "8 PERSONS IN RU"
         9 "9 PERSONS IN RU" ;

label define H200990X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200991X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200992X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200993X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200994X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200995X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200996X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200997X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200998X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H200999X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201000X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201001X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201002X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201003X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201004X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201005X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H201006X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201007X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201008X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H201009X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201010X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201011X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201012X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201013X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 MALE"
         2 "2 FEMALE" ;

label define H201014X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201015X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201016X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201017X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H201018X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201019X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201020X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201021X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201022X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201023X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H201024X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, SPECIAL PROGRAM"
         2 "2 YES, EARLY INTERVENTION SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H201025X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201026X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES, ENROLLED IN SPECIAL EDUCATION"
         2 "2 YES, RELATED SERVICES"
         3 "3 YES, BOTH"
         4 "4 NO"
         91 "91 OTHER" ;

label define H201027X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H201028X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H201029X
         -1 "-1 INAPPLICABLE"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YEARS OLD" ;

label define H201030X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         995 "995 NO SPOUSE IN HOUSE"
         996 "996 MARITAL STATUS UNKNOWN"
         997 "997 LESS THAN 16 YRS OLD" ;

label define H201031X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H201032X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H201033X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H201034X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SPOUSE IN THE HOUSE"
         2 "2 NOT MARRIED/NO SPOUSE"
         3 "3 UNDER 16 - INAPPLICABLE" ;

label define H201035X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H201036X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201037X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201038X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 DISABILITY"
         2 "2 SOME OTHER REASON" ;

label define H201039X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201040X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201041X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201042X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201043X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201044X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201045X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201046X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201047X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201048X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201049X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201050X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201051X
         -1 "-1 INAPPLICABLE"
         1 "1 YES"
         2 "2 NO" ;

label define H201052X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201053X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201054X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN A PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201055X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H201056X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H201057X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JANUARY"
         10 "10 OCTOBER"
         11 "11 NOVEMBER"
         12 "12 DECEMBER"
         2 "2 FEBRUARY"
         3 "3 MARCH"
         4 "4 APRIL"
         5 "5 MAY"
         6 "6 JUNE"
         7 "7 JULY"
         8 "8 AUGUST"
         9 "9 SEPTEMBER" ;

label define H201058X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201059X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201060X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201061X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H201062X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H201063X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETLY UNABLE TO WALK" ;

label define H201064X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO"
         5 "5 COMPLETELY UNABLE TO WALK" ;

label define H201065X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 LONG FORM 1040"
         2 "2 SHORT FORM 1040A"
         3 "3 SHORT FORM 1040EZ"
         91 "91 OTHER" ;

label define H201066X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201067X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0.00" ;

label define H201068X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201069X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201070X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201071X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201072X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201073X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201074X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201075X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201076X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201077X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201078X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201079X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201080X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201081X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H201082X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201083X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H201084X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201085X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201086X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201087X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201088X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         99 "99 ASKED, BUT INAPPLICABLE" ;

label define H201089X
         1 "1 YES"
         2 "2 NO" ;

label define H201090X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201091X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201092X
         -1 "-1 INAPPLICABLE"
         -2 "-2 DETERMINED IN THE PREVIOUS ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201093X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201094X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H201095X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H201096X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H201097X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H201098X
         -1 "-1 INAPPLICABLE"
         -3 "-3 NO DATA IN ROUND"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES - SERVED"
         2 "2 NO - DID NOT SERVE"
         3 "3 UNDER 16 - INAPPLICABLE"
         4 "4 NEVER IN MILITARY" ;

label define H201099X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         144 "$144 - $144" ;

label define H201100X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201101X
         -1 "-1 INAPPLICABLE"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 IMPAIRED NEAR, BUT NOT FAR"
         4 "4 IMPAIRED BOTH NEAR AND FAR"
         5 "5 BLIND" ;

label define H201102X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201103X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201104X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201105X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201106X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201107X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201108X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201109X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201110X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201111X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201112X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201113X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201114X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 SET"
         2 "2 NOT SET" ;

label define H201115X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         4 "4 WEEKS WORKED/EARNINGS USED"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201116X
         1 "1 ORIGINAL RESPONSE USED"
         2 "2 BRACKET CONVERTED"
         3 "3 MISSING VALUES SET TO 0"
         5 "5 CONDITIONAL HOTDECK"
         6 "6 UNCONDITIONAL HOTDECK" ;

label define H201117X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201118X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED" ;

label define H201119X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201120X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H201121X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 NO DIFFICULTY"
         2 "2 SOME DIFFICULTY"
         3 "3 A LOT OF DIFFICULTY"
         4 "4 UNABLE TO DO" ;

label define H201122X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201123X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201124X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201125X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201126X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 YES"
         2 "2 NO" ;

label define H201127X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE ANOTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H201128X
         -1 "-1 INAPPLICABLE"
         -7 "-7 REFUSED"
         -8 "-8 DK"
         -9 "-9 NOT ASCERTAINED"
         1 "1 JOB ENDED"
         10 "10 QUIT TO TAKE OTHER JOB"
         11 "11 UNPAID LEAVE"
         2 "2 BUSINESS DISSOLVED OR SOLD"
         3 "3 RETIRED"
         4 "4 ILLNESS OR INJURY"
         5 "5 LAID OFF"
         6 "6 QUIT TO HAVE A BABY"
         7 "7 QUIT TO GO TO SCHOOL"
         8 "8 QUIT TO TAKE CARE OF HOME OR FAMILY"
         9 "9 QUIT BECAUSE WANTED TIME OFF"
         91 "91 OTHER" ;

label define H201129X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201130X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201131X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201132X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201133X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201134X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201135X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201136X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201137X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201138X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201139X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201140X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201141X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201142X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201143X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         18 "$18 - $18" ;

label define H201144X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201145X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201146X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201147X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         607 "$607 - $607" ;

label define H201148X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201149X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         172 "$172 - $172" ;

label define H201150X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201151X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201152X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201153X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201154X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

label define H201155X
         -9 "-9 NOT ASCERTAINED"
         0 "0"
         607 "$607 - $607" ;

label define H201156X
         -9 "-9 NOT ASCERTAINED"
         0 "0" ;

* ASSOCIATE VARIABLES WITH VALUE LABEL DEFINITIONS;
label value ACTDTY31 H200001X;
label value ACTDTY42 H200002X;
label value ACTDTY53 H200003X;
label value ACTLIM31 H200004X;
label value ACTLIM53 H200005X;
label value ADLHLP31 H200006X;
label value ADLHLP42 H200007X;
label value ADLHLP53 H200008X;
label value ADUPRO42 H200009X;
label value AFDC97 H200010X;
label value AIDHLP31 H200011X;
label value AIDHLP53 H200012X;
label value ALIIMP97 H200013X;
label value AMACHM97 H200014X;
label value AMAEXP97 H200015X;
label value AMAMCD97 H200016X;
label value AMAMCR97 H200017X;
label value AMAOFD97 H200018X;
label value AMAOPR97 H200019X;
label value AMAOPU97 H200020X;
label value AMAOSR97 H200021X;
label value AMAPRV97 H200022X;
label value AMASLF97 H200023X;
label value AMASST97 H200024X;
label value AMASTL97 H200025X;
label value AMATCH97 H200026X;
label value AMAVA97 H200027X;
label value AMAWCP97 H200028X;
label value AMCCHM97 H200029X;
label value AMCEXP97 H200030X;
label value AMCHIR97 H200031X;
label value AMCMCD97 H200032X;
label value AMCMCR97 H200033X;
label value AMCOFD97 H200034X;
label value AMCOPR97 H200035X;
label value AMCOPU97 H200036X;
label value AMCOSR97 H200037X;
label value AMCPRV97 H200038X;
label value AMCSLF97 H200039X;
label value AMCSTL97 H200040X;
label value AMCTCH97 H200041X;
label value AMCVA97 H200042X;
label value AMCWCP97 H200043X;
label value AMDRC97 H200044X;
label value AMECHM97 H200045X;
label value AMEEXP97 H200046X;
label value AMEMCD97 H200047X;
label value AMEMCR97 H200048X;
label value AMEOFD97 H200049X;
label value AMEOPR97 H200050X;
label value AMEOPU97 H200051X;
label value AMEOSR97 H200052X;
label value AMEPRV97 H200053X;
label value AMESLF97 H200054X;
label value AMESTL97 H200055X;
label value AMETCH97 H200056X;
label value AMEVA97 H200057X;
label value AMEWCP97 H200058X;
label value AMNCHM97 H200059X;
label value AMNEXP97 H200060X;
label value AMNMCD97 H200061X;
label value AMNMCR97 H200062X;
label value AMNOFD97 H200063X;
label value AMNOPR97 H200064X;
label value AMNOPU97 H200065X;
label value AMNOSR97 H200066X;
label value AMNPRV97 H200067X;
label value AMNSLF97 H200068X;
label value AMNSTL97 H200069X;
label value AMNTCH97 H200070X;
label value AMNURS97 H200071X;
label value AMNVA97 H200072X;
label value AMNWCP97 H200073X;
label value AMOPTO97 H200074X;
label value AMTCHM97 H200075X;
label value AMTEXP97 H200076X;
label value AMTHER97 H200077X;
label value AMTMCD97 H200078X;
label value AMTMCR97 H200079X;
label value AMTOFD97 H200080X;
label value AMTOPR97 H200081X;
label value AMTOPU97 H200082X;
label value AMTOSR97 H200083X;
label value AMTOTC97 H200084X;
label value AMTPRV97 H200085X;
label value AMTSLF97 H200086X;
label value AMTSTL97 H200087X;
label value AMTTCH97 H200088X;
label value AMTVA97 H200089X;
label value AMTWCP97 H200090X;
label value ANYLIM97 H200091X;
label value BEGRFD31 H200092X;
label value BEGRFD42 H200093X;
label value BEGRFD53 H200094X;
label value BEGRFM31 H200095X;
label value BEGRFM42 H200096X;
label value BEGRFM53 H200097X;
label value BEGRFY31 H200098X;
label value BEGRFY42 H200099X;
label value BEGRFY53 H200100X;
label value BENDIF31 H200101X;
label value BENDIF53 H200102X;
label value BGNWK31 H200103X;
label value BGNWK42 H200104X;
label value BGNWK53 H200105X;
label value BLIND42 H200106X;
label value BSNTY31 H200107X;
label value BSNTY42 H200108X;
label value BSNTY53 H200109X;
label value BUSIMP97 H200110X;
label value CANTPL42 H200111X;
label value CANTSC42 H200112X;
label value CHAP97X H200113X;
label value CHAU97X H200114X;
label value CHDE97X H200115X;
label value CHFE97X H200116X;
label value CHGJ3142 H200117X;
label value CHGJ4253 H200118X;
label value CHJA97X H200119X;
label value CHJL97X H200120X;
label value CHJU97X H200121X;
label value CHLIM42 H200122X;
label value CHLIMP97 H200123X;
label value CHMA97X H200124X;
label value CHMY97X H200125X;
label value CHNO97X H200126X;
label value CHOC97X H200127X;
label value CHOIC31 H200128X;
label value CHOIC42 H200129X;
label value CHOIC53 H200130X;
label value CHPEV97 H200131X;
label value CHSE97X H200132X;
label value CIND31 H200133X;
label value CIND42 H200134X;
label value CIND53 H200135X;
label value CLMDEP97 H200136X;
label value CLMHIP97 H200137X;
label value COCCP31 H200138X;
label value COCCP42 H200139X;
label value COCCP53 H200140X;
label value COGLIM31 H200141X;
label value COGLIM53 H200142X;
label value CSHIMP97 H200143X;
label value DADPRO42 H200144X;
label value DEAF42 H200145X;
label value DEDUCT97 H200146X;
label value DEPDNT97 H200147X;
label value DIDSERVE H200148X;
label value DISVW31X H200149X;
label value DISVW42X H200150X;
label value DISVW53X H200151X;
label value DIVIMP97 H200152X;
label value DOBMM H200153X;
label value DOBYY H200154X;
label value DPINRU97 H200155X;
label value DPOTSD97 H200156X;
label value DPTSHT42 H200157X;
label value DVGCHM97 H200158X;
label value DVGEN97 H200159X;
label value DVGEXP97 H200160X;
label value DVGMCD97 H200161X;
label value DVGMCR97 H200162X;
label value DVGOFD97 H200163X;
label value DVGOPR97 H200164X;
label value DVGOPU97 H200165X;
label value DVGOSR97 H200166X;
label value DVGPRV97 H200167X;
label value DVGSLF97 H200168X;
label value DVGSTL97 H200169X;
label value DVGTCH97 H200170X;
label value DVGVA97 H200171X;
label value DVGWCP97 H200172X;
label value DVOCHM97 H200173X;
label value DVOEXP97 H200174X;
label value DVOMCD97 H200175X;
label value DVOMCR97 H200176X;
label value DVOOFD97 H200177X;
label value DVOOPR97 H200178X;
label value DVOOPU97 H200179X;
label value DVOOSR97 H200180X;
label value DVOPRV97 H200181X;
label value DVORTH97 H200182X;
label value DVOSLF97 H200183X;
label value DVOSTL97 H200184X;
label value DVOTCH97 H200185X;
label value DVOVA97 H200186X;
label value DVOWCP97 H200187X;
label value DVTCHM97 H200188X;
label value DVTEXP97 H200189X;
label value DVTMCD97 H200190X;
label value DVTMCR97 H200191X;
label value DVTOFD97 H200192X;
label value DVTOPR97 H200193X;
label value DVTOPU97 H200194X;
label value DVTOSR97 H200195X;
label value DVTOT97 H200196X;
label value DVTPRV97 H200197X;
label value DVTSLF97 H200198X;
label value DVTSTL97 H200199X;
label value DVTTCH97 H200200X;
label value DVTVA97 H200201X;
label value DVTWCP97 H200202X;
label value EDUCYR31 H200203X;
label value EDUCYR42 H200204X;
label value EDUCYR53 H200205X;
label value EDUCYR97 H200206X;
label value EICRDT97 H200207X;
label value ELDISC97 H200208X;
label value ELGRND31 H200209X;
label value ELGRND42 H200210X;
label value ELGRND53 H200211X;
label value ELGRND97 H200212X;
label value ELIGIBLE H200213X;
label value EMPST31 H200214X;
label value EMPST42 H200215X;
label value EMPST53 H200216X;
label value ENDRFD31 H200217X;
label value ENDRFD42 H200218X;
label value ENDRFD53 H200219X;
label value ENDRFD97 H200220X;
label value ENDRFM31 H200221X;
label value ENDRFM42 H200222X;
label value ENDRFM53 H200223X;
label value ENDRFM97 H200224X;
label value ENDRFY31 H200225X;
label value ENDRFY42 H200226X;
label value ENDRFY53 H200227X;
label value ENDRFY97 H200228X;
label value ENDWK31 H200229X;
label value ENDWK42 H200230X;
label value ENDWK53 H200231X;
label value ERDCHM97 H200232X;
label value ERDEXP97 H200233X;
label value ERDMCD97 H200234X;
label value ERDMCR97 H200235X;
label value ERDOFD97 H200236X;
label value ERDOPR97 H200237X;
label value ERDOPU97 H200238X;
label value ERDOSR97 H200239X;
label value ERDPRV97 H200240X;
label value ERDSLF97 H200241X;
label value ERDSTL97 H200242X;
label value ERDTCH97 H200243X;
label value ERDVA97 H200244X;
label value ERDWCP97 H200245X;
label value ERFCHM97 H200246X;
label value ERFEXP97 H200247X;
label value ERFMCD97 H200248X;
label value ERFMCR97 H200249X;
label value ERFOFD97 H200250X;
label value ERFOPR97 H200251X;
label value ERFOPU97 H200252X;
label value ERFOSR97 H200253X;
label value ERFPRV97 H200254X;
label value ERFSLF97 H200255X;
label value ERFSTL97 H200256X;
label value ERFTCH97 H200257X;
label value ERFVA97 H200258X;
label value ERFWCP97 H200259X;
label value ERTOT97 H200260X;
label value EVRETIRE H200261X;
label value EVRWRK H200262X;
label value FAMCNS42 H200263X;
label value FAMRFPYR H200264X;
label value FAMSZE31 H200265X;
label value FAMSZE42 H200266X;
label value FAMSZE53 H200267X;
label value FAMSZE97 H200268X;
label value FARIMP97 H200269X;
label value FCRP1231 H200270X;
label value FILEDR97 H200271X;
label value FILER97 H200272X;
label value FLSTAT97 H200273X;
label value FMRS1231 H200274X;
label value FNGRDF31 H200275X;
label value FNGRDF53 H200276X;
label value FOODCT97 H200277X;
label value FOODMN97 H200278X;
label value FOODST97 H200279X;
label value FOODVL97 H200280X;
label value FTSTU31X H200281X;
label value FTSTU42X H200282X;
label value FTSTU53X H200283X;
label value FTSTU97X H200284X;
label value FYFAMTYP H200285X;
label value GETSIC42 H200286X;
label value HAVFUN42 H200287X;
label value HEARAD42 H200288X;
label value HEARDI42 H200289X;
label value HEARMO42 H200290X;
label value HEARNG42 H200291X;
label value HEARSM42 H200292X;
label value HELD31X H200293X;
label value HELD42X H200294X;
label value HELD53X H200295X;
label value HEPSHT42 H200296X;
label value HGTFT42 H200297X;
label value HGTIN42 H200298X;
label value HHACHM97 H200299X;
label value HHAEXP97 H200300X;
label value HHAGD97 H200301X;
label value HHAMCD97 H200302X;
label value HHAMCR97 H200303X;
label value HHAOFD97 H200304X;
label value HHAOPR97 H200305X;
label value HHAOPU97 H200306X;
label value HHAOSR97 H200307X;
label value HHAPRV97 H200308X;
label value HHASLF97 H200309X;
label value HHASTL97 H200310X;
label value HHATCH97 H200311X;
label value HHAVA97 H200312X;
label value HHAWCP97 H200313X;
label value HHINDD97 H200314X;
label value HHINFD97 H200315X;
label value HHNCHM97 H200316X;
label value HHNEXP97 H200317X;
label value HHNMCD97 H200318X;
label value HHNMCR97 H200319X;
label value HHNOFD97 H200320X;
label value HHNOPR97 H200321X;
label value HHNOPU97 H200322X;
label value HHNOSR97 H200323X;
label value HHNPRV97 H200324X;
label value HHNSLF97 H200325X;
label value HHNSTL97 H200326X;
label value HHNTCH97 H200327X;
label value HHNVA97 H200328X;
label value HHNWCP97 H200329X;
label value HHTOTD97 H200330X;
label value HIDEG31 H200331X;
label value HIDEG42 H200332X;
label value HIDEG53 H200333X;
label value HIDEG97 H200334X;
label value HISPANX H200335X;
label value HISPCAT H200336X;
label value HLTHY42 H200337X;
label value HOMEBH42 H200338X;
label value HOUR31 H200339X;
label value HOUR42 H200340X;
label value HOUR53 H200341X;
label value HPDAP97 H200342X;
label value HPDAU97 H200343X;
label value HPDDE97 H200344X;
label value HPDFE97 H200345X;
label value HPDJA97 H200346X;
label value HPDJL97 H200347X;
label value HPDJU97 H200348X;
label value HPDMA97 H200349X;
label value HPDMY97 H200350X;
label value HPDNO97 H200351X;
label value HPDOC97 H200352X;
label value HPDSE97 H200353X;
label value HPEAP97 H200354X;
label value HPEAU97 H200355X;
label value HPEDE97 H200356X;
label value HPEFE97 H200357X;
label value HPEJA97 H200358X;
label value HPEJL97 H200359X;
label value HPEJU97 H200360X;
label value HPEMA97 H200361X;
label value HPEMY97 H200362X;
label value HPENO97 H200363X;
label value HPEOC97 H200364X;
label value HPESE97 H200365X;
label value HPNAP97 H200366X;
label value HPNAU97 H200367X;
label value HPNDE97 H200368X;
label value HPNFE97 H200369X;
label value HPNJA97 H200370X;
label value HPNJL97 H200371X;
label value HPNJU97 H200372X;
label value HPNMA97 H200373X;
label value HPNMY97 H200374X;
label value HPNNO97 H200375X;
label value HPNOC97 H200376X;
label value HPNSE97 H200377X;
label value HPOAP97 H200378X;
label value HPOAU97 H200379X;
label value HPODE97 H200380X;
label value HPOFE97 H200381X;
label value HPOJA97 H200382X;
label value HPOJL97 H200383X;
label value HPOJU97 H200384X;
label value HPOMA97 H200385X;
label value HPOMY97 H200386X;
label value HPONO97 H200387X;
label value HPOOC97 H200388X;
label value HPOSE97 H200389X;
label value HPRAP97 H200390X;
label value HPRAU97 H200391X;
label value HPRDE97 H200392X;
label value HPRFE97 H200393X;
label value HPRJA97 H200394X;
label value HPRJL97 H200395X;
label value HPRJU97 H200396X;
label value HPRMA97 H200397X;
label value HPRMY97 H200398X;
label value HPRNO97 H200399X;
label value HPROC97 H200400X;
label value HPRSE97 H200401X;
label value HPSAP97 H200402X;
label value HPSAU97 H200403X;
label value HPSDE97 H200404X;
label value HPSFE97 H200405X;
label value HPSJA97 H200406X;
label value HPSJL97 H200407X;
label value HPSJU97 H200408X;
label value HPSMA97 H200409X;
label value HPSMY97 H200410X;
label value HPSNO97 H200411X;
label value HPSOC97 H200412X;
label value HPSSE97 H200413X;
label value HRHOW31 H200414X;
label value HRHOW42 H200415X;
label value HRHOW53 H200416X;
label value HRWG31X H200417X;
label value HRWG42X H200418X;
label value HRWG53X H200419X;
label value HRWGIM31 H200420X;
label value HRWGIM42 H200421X;
label value HRWGIM53 H200422X;
label value HSELIM31 H200423X;
label value HSELIM53 H200424X;
label value IADLHP31 H200425X;
label value IADLHP42 H200426X;
label value IADLHP53 H200427X;
label value INRU1231 H200428X;
label value INSAP97X H200429X;
label value INSAU97X H200430X;
label value INSC1231 H200431X;
label value INSCOP31 H200432X;
label value INSCOP42 H200433X;
label value INSCOP53 H200434X;
label value INSCOP97 H200435X;
label value INSCOPE H200436X;
label value INSCOV97 H200437X;
label value INSDE97X H200438X;
label value INSFE97X H200439X;
label value INSJA97X H200440X;
label value INSJL97X H200441X;
label value INSJU97X H200442X;
label value INSMA97X H200443X;
label value INSMY97X H200444X;
label value INSNO97X H200445X;
label value INSOC97X H200446X;
label value INSSE97X H200447X;
label value INTIMP97 H200448X;
label value INTRTX97 H200449X;
label value IPDCHM97 H200450X;
label value IPDEXP97 H200451X;
label value IPDIS97 H200452X;
label value IPDMCD97 H200453X;
label value IPDMCR97 H200454X;
label value IPDOFD97 H200455X;
label value IPDOPR97 H200456X;
label value IPDOPU97 H200457X;
label value IPDOSR97 H200458X;
label value IPDPRV97 H200459X;
label value IPDSLF97 H200460X;
label value IPDSTL97 H200461X;
label value IPDTCH97 H200462X;
label value IPDVA97 H200463X;
label value IPDWCP97 H200464X;
label value IPFCHM97 H200465X;
label value IPFEXP97 H200466X;
label value IPFMCD97 H200467X;
label value IPFMCR97 H200468X;
label value IPFOFD97 H200469X;
label value IPFOPR97 H200470X;
label value IPFOPU97 H200471X;
label value IPFOSR97 H200472X;
label value IPFPRV97 H200473X;
label value IPFSLF97 H200474X;
label value IPFSTL97 H200475X;
label value IPFTCH97 H200476X;
label value IPFVA97 H200477X;
label value IPFWCP97 H200478X;
label value IPNGTD97 H200479X;
label value IPZERO97 H200480X;
label value IRAIMP97 H200481X;
label value IRATAX97 H200482X;
label value ITMEXP97 H200483X;
label value JNTPID97 H200484X;
label value JOBORG31 H200485X;
label value JOBORG42 H200486X;
label value JOBORG53 H200487X;
label value JTINRU97 H200488X;
label value KEYNESS H200489X;
label value KIDPRO42 H200490X;
label value LFTDIF31 H200491X;
label value LFTDIF53 H200492X;
label value LIFSKL42 H200493X;
label value LIMACT42 H200494X;
label value LMOACT42 H200495X;
label value MARRY31X H200496X;
label value MARRY42X H200497X;
label value MARRY53X H200498X;
label value MARRY97X H200499X;
label value MCDAP97 H200500X;
label value MCDAP97X H200501X;
label value MCDAU97 H200502X;
label value MCDAU97X H200503X;
label value MCDDE97 H200504X;
label value MCDDE97X H200505X;
label value MCDEV97 H200506X;
label value MCDFE97 H200507X;
label value MCDFE97X H200508X;
label value MCDJA97 H200509X;
label value MCDJA97X H200510X;
label value MCDJL97 H200511X;
label value MCDJL97X H200512X;
label value MCDJU97 H200513X;
label value MCDJU97X H200514X;
label value MCDMA97 H200515X;
label value MCDMA97X H200516X;
label value MCDMY97 H200517X;
label value MCDMY97X H200518X;
label value MCDNO97 H200519X;
label value MCDNO97X H200520X;
label value MCDOC97 H200521X;
label value MCDOC97X H200522X;
label value MCDSE97 H200523X;
label value MCDSE97X H200524X;
label value MCRAP97 H200525X;
label value MCRAP97X H200526X;
label value MCRAU97 H200527X;
label value MCRAU97X H200528X;
label value MCRDE97 H200529X;
label value MCRDE97X H200530X;
label value MCREV97 H200531X;
label value MCRFE97 H200532X;
label value MCRFE97X H200533X;
label value MCRJA97 H200534X;
label value MCRJA97X H200535X;
label value MCRJL97 H200536X;
label value MCRJL97X H200537X;
label value MCRJU97 H200538X;
label value MCRJU97X H200539X;
label value MCRMA97 H200540X;
label value MCRMA97X H200541X;
label value MCRMY97 H200542X;
label value MCRMY97X H200543X;
label value MCRNO97 H200544X;
label value MCRNO97X H200545X;
label value MCROC97 H200546X;
label value MCROC97X H200547X;
label value MCRSE97 H200548X;
label value MCRSE97X H200549X;
label value MEXAMT97 H200550X;
label value MILDIF31 H200551X;
label value MILDIF53 H200552X;
label value MMRSHT42 H200553X;
label value MNHLTH31 H200554X;
label value MNHLTH42 H200555X;
label value MNHLTH53 H200556X;
label value MNPROX31 H200557X;
label value MNPROX42 H200558X;
label value MNPROX53 H200559X;
label value MOMPRO42 H200560X;
label value MORE31 H200561X;
label value MORE42 H200562X;
label value MORE53 H200563X;
label value MORJOB31 H200564X;
label value MORJOB42 H200565X;
label value MORJOB53 H200566X;
label value MSA53 H200567X;
label value MSA97 H200568X;
label value NERVAF42 H200569X;
label value NTHLTH42 H200570X;
label value NTMDED97 H200571X;
label value NUMDPT42 H200572X;
label value NUMEMP31 H200573X;
label value NUMEMP42 H200574X;
label value NUMEMP53 H200575X;
label value NUMPOL42 H200576X;
label value NWK31 H200577X;
label value NWK42 H200578X;
label value NWK53 H200579X;
label value OBACHM97 H200580X;
label value OBAEXP97 H200581X;
label value OBAMCD97 H200582X;
label value OBAMCR97 H200583X;
label value OBAOFD97 H200584X;
label value OBAOPR97 H200585X;
label value OBAOPU97 H200586X;
label value OBAOSR97 H200587X;
label value OBAPRV97 H200588X;
label value OBASLF97 H200589X;
label value OBASST97 H200590X;
label value OBASTL97 H200591X;
label value OBATCH97 H200592X;
label value OBAVA97 H200593X;
label value OBAWCP97 H200594X;
label value OBCCHM97 H200595X;
label value OBCEXP97 H200596X;
label value OBCHIR97 H200597X;
label value OBCMCD97 H200598X;
label value OBCMCR97 H200599X;
label value OBCOFD97 H200600X;
label value OBCOPR97 H200601X;
label value OBCOPU97 H200602X;
label value OBCOSR97 H200603X;
label value OBCPRV97 H200604X;
label value OBCSLF97 H200605X;
label value OBCSTL97 H200606X;
label value OBCTCH97 H200607X;
label value OBCVA97 H200608X;
label value OBCWCP97 H200609X;
label value OBDCHM97 H200610X;
label value OBDEXP97 H200611X;
label value OBDMCD97 H200612X;
label value OBDMCR97 H200613X;
label value OBDOFD97 H200614X;
label value OBDOPR97 H200615X;
label value OBDOPU97 H200616X;
label value OBDOSR97 H200617X;
label value OBDPRV97 H200618X;
label value OBDRV97 H200619X;
label value OBDSLF97 H200620X;
label value OBDSTL97 H200621X;
label value OBDTCH97 H200622X;
label value OBDVA97 H200623X;
label value OBDWCP97 H200624X;
label value OBECHM97 H200625X;
label value OBEEXP97 H200626X;
label value OBEMCD97 H200627X;
label value OBEMCR97 H200628X;
label value OBEOFD97 H200629X;
label value OBEOPR97 H200630X;
label value OBEOPU97 H200631X;
label value OBEOSR97 H200632X;
label value OBEPRV97 H200633X;
label value OBESLF97 H200634X;
label value OBESTL97 H200635X;
label value OBETCH97 H200636X;
label value OBEVA97 H200637X;
label value OBEWCP97 H200638X;
label value OBNCHM97 H200639X;
label value OBNEXP97 H200640X;
label value OBNMCD97 H200641X;
label value OBNMCR97 H200642X;
label value OBNOFD97 H200643X;
label value OBNOPR97 H200644X;
label value OBNOPU97 H200645X;
label value OBNOSR97 H200646X;
label value OBNPRV97 H200647X;
label value OBNSLF97 H200648X;
label value OBNSTL97 H200649X;
label value OBNTCH97 H200650X;
label value OBNURS97 H200651X;
label value OBNVA97 H200652X;
label value OBNWCP97 H200653X;
label value OBOCHM97 H200654X;
label value OBOEXP97 H200655X;
label value OBOMCD97 H200656X;
label value OBOMCR97 H200657X;
label value OBOOFD97 H200658X;
label value OBOOPR97 H200659X;
label value OBOOPU97 H200660X;
label value OBOOSR97 H200661X;
label value OBOPRV97 H200662X;
label value OBOPTO97 H200663X;
label value OBOSLF97 H200664X;
label value OBOSTL97 H200665X;
label value OBOTCH97 H200666X;
label value OBOTHV97 H200667X;
label value OBOVA97 H200668X;
label value OBOWCP97 H200669X;
label value OBTCHM97 H200670X;
label value OBTEXP97 H200671X;
label value OBTHER97 H200672X;
label value OBTMCD97 H200673X;
label value OBTMCR97 H200674X;
label value OBTOFD97 H200675X;
label value OBTOPR97 H200676X;
label value OBTOPU97 H200677X;
label value OBTOSR97 H200678X;
label value OBTOTV97 H200679X;
label value OBTPRV97 H200680X;
label value OBTSLF97 H200681X;
label value OBTSTL97 H200682X;
label value OBTTCH97 H200683X;
label value OBTVA97 H200684X;
label value OBTWCP97 H200685X;
label value OBVCHM97 H200686X;
label value OBVEXP97 H200687X;
label value OBVMCD97 H200688X;
label value OBVMCR97 H200689X;
label value OBVOFD97 H200690X;
label value OBVOPR97 H200691X;
label value OBVOPU97 H200692X;
label value OBVOSR97 H200693X;
label value OBVPRV97 H200694X;
label value OBVSLF97 H200695X;
label value OBVSTL97 H200696X;
label value OBVTCH97 H200697X;
label value OBVVA97 H200698X;
label value OBVWCP97 H200699X;
label value OCUPTH42 H200700X;
label value OFFER31X H200701X;
label value OFFER42X H200702X;
label value OFFER53X H200703X;
label value OPAAP97 H200704X;
label value OPAAU97 H200705X;
label value OPADE97 H200706X;
label value OPAEV97 H200707X;
label value OPAFE97 H200708X;
label value OPAJA97 H200709X;
label value OPAJL97 H200710X;
label value OPAJU97 H200711X;
label value OPAMA97 H200712X;
label value OPAMY97 H200713X;
label value OPANO97 H200714X;
label value OPAOC97 H200715X;
label value OPASE97 H200716X;
label value OPBAP97 H200717X;
label value OPBAU97 H200718X;
label value OPBDE97 H200719X;
label value OPBEV97 H200720X;
label value OPBFE97 H200721X;
label value OPBJA97 H200722X;
label value OPBJL97 H200723X;
label value OPBJU97 H200724X;
label value OPBMA97 H200725X;
label value OPBMY97 H200726X;
label value OPBNO97 H200727X;
label value OPBOC97 H200728X;
label value OPBSE97 H200729X;
label value OPDCHM97 H200730X;
label value OPDEXP97 H200731X;
label value OPDMCD97 H200732X;
label value OPDMCR97 H200733X;
label value OPDOFD97 H200734X;
label value OPDOPR97 H200735X;
label value OPDOPU97 H200736X;
label value OPDOSR97 H200737X;
label value OPDPRV97 H200738X;
label value OPDRV97 H200739X;
label value OPDSLF97 H200740X;
label value OPDSTL97 H200741X;
label value OPDTCH97 H200742X;
label value OPDVA97 H200743X;
label value OPDWCP97 H200744X;
label value OPFCHM97 H200745X;
label value OPFEXP97 H200746X;
label value OPFMCD97 H200747X;
label value OPFMCR97 H200748X;
label value OPFOFD97 H200749X;
label value OPFOPR97 H200750X;
label value OPFOPU97 H200751X;
label value OPFOSR97 H200752X;
label value OPFPRV97 H200753X;
label value OPFSLF97 H200754X;
label value OPFSTL97 H200755X;
label value OPFTCH97 H200756X;
label value OPFVA97 H200757X;
label value OPFWCP97 H200758X;
label value OPOCHM97 H200759X;
label value OPOEXP97 H200760X;
label value OPOMCD97 H200761X;
label value OPOMCR97 H200762X;
label value OPOOFD97 H200763X;
label value OPOOPR97 H200764X;
label value OPOOPU97 H200765X;
label value OPOOSR97 H200766X;
label value OPOPRV97 H200767X;
label value OPOSLF97 H200768X;
label value OPOSTL97 H200769X;
label value OPOTCH97 H200770X;
label value OPOTHV97 H200771X;
label value OPOVA97 H200772X;
label value OPOWCP97 H200773X;
label value OPPCHM97 H200774X;
label value OPPEXP97 H200775X;
label value OPPMCD97 H200776X;
label value OPPMCR97 H200777X;
label value OPPOFD97 H200778X;
label value OPPOPR97 H200779X;
label value OPPOPU97 H200780X;
label value OPPOSR97 H200781X;
label value OPPPRV97 H200782X;
label value OPPSLF97 H200783X;
label value OPPSTL97 H200784X;
label value OPPTCH97 H200785X;
label value OPPVA97 H200786X;
label value OPPWCP97 H200787X;
label value OPSCHM97 H200788X;
label value OPSEXP97 H200789X;
label value OPSMCD97 H200790X;
label value OPSMCR97 H200791X;
label value OPSOFD97 H200792X;
label value OPSOPR97 H200793X;
label value OPSOPU97 H200794X;
label value OPSOSR97 H200795X;
label value OPSPRV97 H200796X;
label value OPSSLF97 H200797X;
label value OPSSTL97 H200798X;
label value OPSTCH97 H200799X;
label value OPSVA97 H200800X;
label value OPSWCP97 H200801X;
label value OPTOTV97 H200802X;
label value OPVCHM97 H200803X;
label value OPVEXP97 H200804X;
label value OPVMCD97 H200805X;
label value OPVMCR97 H200806X;
label value OPVOFD97 H200807X;
label value OPVOPR97 H200808X;
label value OPVOPU97 H200809X;
label value OPVOSR97 H200810X;
label value OPVPRV97 H200811X;
label value OPVSLF97 H200812X;
label value OPVSTL97 H200813X;
label value OPVTCH97 H200814X;
label value OPVVA97 H200815X;
label value OPVWCP97 H200816X;
label value OTHCHM97 H200817X;
label value OTHEXP97 H200818X;
label value OTHIMP97 H200819X;
label value OTHMCD97 H200820X;
label value OTHMCR97 H200821X;
label value OTHOFD97 H200822X;
label value OTHOPR97 H200823X;
label value OTHOPU97 H200824X;
label value OTHOSR97 H200825X;
label value OTHPRV97 H200826X;
label value OTHSLF97 H200827X;
label value OTHSTL97 H200828X;
label value OTHSVC42 H200829X;
label value OTHTCH97 H200830X;
label value OTHVA97 H200831X;
label value OTHWCP97 H200832X;
label value PANEL97 H200833X;
label value PAYDR31 H200834X;
label value PAYDR42 H200835X;
label value PAYDR53 H200836X;
label value PAYVAC31 H200837X;
label value PAYVAC42 H200838X;
label value PAYVAC53 H200839X;
label value PDKAP97 H200840X;
label value PDKAU97 H200841X;
label value PDKDE97 H200842X;
label value PDKFE97 H200843X;
label value PDKJA97 H200844X;
label value PDKJL97 H200845X;
label value PDKJU97 H200846X;
label value PDKMA97 H200847X;
label value PDKMY97 H200848X;
label value PDKNO97 H200849X;
label value PDKOC97 H200850X;
label value PDKSE97 H200851X;
label value PEGAP97 H200852X;
label value PEGAU97 H200853X;
label value PEGDE97 H200854X;
label value PEGFE97 H200855X;
label value PEGJA97 H200856X;
label value PEGJL97 H200857X;
label value PEGJU97 H200858X;
label value PEGMA97 H200859X;
label value PEGMY97 H200860X;
label value PEGNO97 H200861X;
label value PEGOC97 H200862X;
label value PEGSE97 H200863X;
label value PENIMP97 H200864X;
label value PHYTHR42 H200865X;
label value PLYLIM42 H200866X;
label value PNGAP97 H200867X;
label value PNGAU97 H200868X;
label value PNGDE97 H200869X;
label value PNGFE97 H200870X;
label value PNGJA97 H200871X;
label value PNGJL97 H200872X;
label value PNGJU97 H200873X;
label value PNGMA97 H200874X;
label value PNGMY97 H200875X;
label value PNGNO97 H200876X;
label value PNGOC97 H200877X;
label value PNGSE97 H200878X;
label value POGAP97 H200879X;
label value POGAU97 H200880X;
label value POGDE97 H200881X;
label value POGFE97 H200882X;
label value POGJA97 H200883X;
label value POGJL97 H200884X;
label value POGJU97 H200885X;
label value POGMA97 H200886X;
label value POGMY97 H200887X;
label value POGNO97 H200888X;
label value POGOC97 H200889X;
label value POGSE97 H200890X;
label value POLSHT42 H200891X;
label value POUAP97 H200892X;
label value POUAU97 H200893X;
label value POUDE97 H200894X;
label value POUFE97 H200895X;
label value POUJA97 H200896X;
label value POUJL97 H200897X;
label value POUJU97 H200898X;
label value POUMA97 H200899X;
label value POUMY97 H200900X;
label value POUNO97 H200901X;
label value POUOC97 H200902X;
label value POUSE97 H200903X;
label value POVCAT97 H200904X;
label value PRIAP97 H200905X;
label value PRIAU97 H200906X;
label value PRIDE97 H200907X;
label value PRIFE97 H200908X;
label value PRIJA97 H200909X;
label value PRIJL97 H200910X;
label value PRIJU97 H200911X;
label value PRIMA97 H200912X;
label value PRIMY97 H200913X;
label value PRINO97 H200914X;
label value PRIOC97 H200915X;
label value PRISE97 H200916X;
label value PROXY31 H200917X;
label value PROXY42 H200918X;
label value PROXY53 H200919X;
label value PROXY97 H200920X;
label value PRSAP97 H200921X;
label value PRSAU97 H200922X;
label value PRSDE97 H200923X;
label value PRSFE97 H200924X;
label value PRSJA97 H200925X;
label value PRSJL97 H200926X;
label value PRSJU97 H200927X;
label value PRSMA97 H200928X;
label value PRSMY97 H200929X;
label value PRSNO97 H200930X;
label value PRSOC97 H200931X;
label value PRSSE97 H200932X;
label value PRVEV97 H200933X;
label value PSTATS31 H200934X;
label value PSTATS42 H200935X;
label value PSTATS53 H200936X;
label value PSYCNS42 H200937X;
label value PUBAP97X H200938X;
label value PUBAU97X H200939X;
label value PUBDE97X H200940X;
label value PUBFE97X H200941X;
label value PUBIMP97 H200942X;
label value PUBJA97X H200943X;
label value PUBJL97X H200944X;
label value PUBJU97X H200945X;
label value PUBMA97X H200946X;
label value PUBMY97X H200947X;
label value PUBNO97X H200948X;
label value PUBOC97X H200949X;
label value PUBSE97X H200950X;
label value RACETHNX H200951X;
label value RACEX H200952X;
label value RCHDIF31 H200953X;
label value RCHDIF53 H200954X;
label value READIN42 H200955X;
label value READNW42 H200956X;
label value RECPEP42 H200957X;
label value RECTHR42 H200958X;
label value REFIMP97 H200959X;
label value REGION31 H200960X;
label value REGION42 H200961X;
label value REGION53 H200962X;
label value REGION97 H200963X;
label value RESP31 H200964X;
label value RESP42 H200965X;
label value RESP53 H200966X;
label value RESP97 H200967X;
label value RETPLN31 H200968X;
label value RETPLN42 H200969X;
label value RETPLN53 H200970X;
label value RFREL31X H200971X;
label value RFREL42X H200972X;
label value RFREL53X H200973X;
label value RFREL97X H200974X;
label value RNDFLG31 H200975X;
label value RTHLTH31 H200976X;
label value RTHLTH42 H200977X;
label value RTHLTH53 H200978X;
label value RTPROX31 H200979X;
label value RTPROX42 H200980X;
label value RTPROX53 H200981X;
label value RUCLAS31 H200982X;
label value RUCLAS42 H200983X;
label value RUCLAS53 H200984X;
label value RUCLAS97 H200985X;
label value RUSIZE31 H200986X;
label value RUSIZE42 H200987X;
label value RUSIZE53 H200988X;
label value RUSIZE97 H200989X;
label value RXCHM97 H200990X;
label value RXEXP97 H200991X;
label value RXMCD97 H200992X;
label value RXMCR97 H200993X;
label value RXOFD97 H200994X;
label value RXOPR97 H200995X;
label value RXOPU97 H200996X;
label value RXOSR97 H200997X;
label value RXPRV97 H200998X;
label value RXSLF97 H200999X;
label value RXSTL97 H201000X;
label value RXTOT97 H201001X;
label value RXVA97 H201002X;
label value RXWCP97 H201003X;
label value SALIMP97 H201004X;
label value SCHLBH42 H201005X;
label value SCHLIM31 H201006X;
label value SCHLIM53 H201007X;
label value SCHPRO42 H201008X;
label value SEEDIF42 H201009X;
label value SELFCM31 H201010X;
label value SELFCM42 H201011X;
label value SELFCM53 H201012X;
label value SEX H201013X;
label value SHFTWK31 H201014X;
label value SHFTWK42 H201015X;
label value SHFTWK53 H201016X;
label value SIBPRO42 H201017X;
label value SICPAY31 H201018X;
label value SICPAY42 H201019X;
label value SICPAY53 H201020X;
label value SOCLIM31 H201021X;
label value SOCLIM53 H201022X;
label value SPCHTH42 H201023X;
label value SPCPRO42 H201024X;
label value SPCSCH42 H201025X;
label value SPECED42 H201026X;
label value SPOUID31 H201027X;
label value SPOUID42 H201028X;
label value SPOUID53 H201029X;
label value SPOUID97 H201030X;
label value SPOUIN31 H201031X;
label value SPOUIN42 H201032X;
label value SPOUIN53 H201033X;
label value SPOUIN97 H201034X;
label value SPRPRO42 H201035X;
label value SSCIMP97 H201036X;
label value SSECTX97 H201037X;
label value SSIDIS97 H201038X;
label value SSIIMP97 H201039X;
label value STAAP97 H201040X;
label value STAAU97 H201041X;
label value STADE97 H201042X;
label value STAFE97 H201043X;
label value STAJA97 H201044X;
label value STAJL97 H201045X;
label value STAJU97 H201046X;
label value STAMA97 H201047X;
label value STAMY97 H201048X;
label value STANO97 H201049X;
label value STAOC97 H201050X;
label value STASE97 H201051X;
label value STJBDD31 H201052X;
label value STJBDD42 H201053X;
label value STJBDD53 H201054X;
label value STJBMM31 H201055X;
label value STJBMM42 H201056X;
label value STJBMM53 H201057X;
label value STJBYY31 H201058X;
label value STJBYY42 H201059X;
label value STJBYY53 H201060X;
label value STNDIF31 H201061X;
label value STNDIF53 H201062X;
label value STPDIF31 H201063X;
label value STPDIF53 H201064X;
label value TAXFRM97 H201065X;
label value TOTCHM97 H201066X;
label value TOTDED97 H201067X;
label value TOTEXP97 H201068X;
label value TOTMCD97 H201069X;
label value TOTMCR97 H201070X;
label value TOTOFD97 H201071X;
label value TOTOPR97 H201072X;
label value TOTOPU97 H201073X;
label value TOTOSR97 H201074X;
label value TOTPRV97 H201075X;
label value TOTSLF97 H201076X;
label value TOTSTL97 H201077X;
label value TOTTCH97 H201078X;
label value TOTVA97 H201079X;
label value TOTWCP97 H201080X;
label value TRBLE42 H201081X;
label value TRTIMP97 H201082X;
label value TUTOR42 H201083X;
label value UNABLE31 H201084X;
label value UNABLE53 H201085X;
label value UNEIMP97 H201086X;
label value UNEMTX97 H201087X;
label value UNHAP42 H201088X;
label value UNINS97 H201089X;
label value UNION31 H201090X;
label value UNION42 H201091X;
label value UNION53 H201092X;
label value VETIMP97 H201093X;
label value VETKOR H201094X;
label value VETOTH H201095X;
label value VETPVIET H201096X;
label value VETVIET H201097X;
label value VETWW H201098X;
label value VISCHM97 H201099X;
label value VISEXP97 H201100X;
label value VISION42 H201101X;
label value VISMCD97 H201102X;
label value VISMCR97 H201103X;
label value VISOFD97 H201104X;
label value VISOPR97 H201105X;
label value VISOPU97 H201106X;
label value VISOSR97 H201107X;
label value VISPRV97 H201108X;
label value VISSLF97 H201109X;
label value VISSTL97 H201110X;
label value VISTCH97 H201111X;
label value VISVA97 H201112X;
label value VISWCP97 H201113X;
label value VOCSVC42 H201114X;
label value WAGIMP97 H201115X;
label value WCPIMP97 H201116X;
label value WGTLB42 H201117X;
label value WGTOZ42 H201118X;
label value WILFIL97 H201119X;
label value WLKDIF31 H201120X;
label value WLKDIF53 H201121X;
label value WLKLIM31 H201122X;
label value WLKLIM53 H201123X;
label value WRGLAS42 H201124X;
label value WRKLIM31 H201125X;
label value WRKLIM53 H201126X;
label value YCHJ3142 H201127X;
label value YCHJ4253 H201128X;
label value ZIDCHM97 H201129X;
label value ZIDEXP97 H201130X;
label value ZIDMCD97 H201131X;
label value ZIDMCR97 H201132X;
label value ZIDOFD97 H201133X;
label value ZIDOPR97 H201134X;
label value ZIDOPU97 H201135X;
label value ZIDOSR97 H201136X;
label value ZIDPRV97 H201137X;
label value ZIDSLF97 H201138X;
label value ZIDSTL97 H201139X;
label value ZIDTCH97 H201140X;
label value ZIDVA97 H201141X;
label value ZIDWCP97 H201142X;
label value ZIFCHM97 H201143X;
label value ZIFEXP97 H201144X;
label value ZIFMCD97 H201145X;
label value ZIFMCR97 H201146X;
label value ZIFOFD97 H201147X;
label value ZIFOPR97 H201148X;
label value ZIFOPU97 H201149X;
label value ZIFOSR97 H201150X;
label value ZIFPRV97 H201151X;
label value ZIFSLF97 H201152X;
label value ZIFSTL97 H201153X;
label value ZIFTCH97 H201154X;
label value ZIFVA97 H201155X;
label value ZIFWCP97 H201156X;

*DISPLAY A DESCRIPTION OF STATA FILE;
describe;

*LIST FIRST 20 OBSERVATIONS IN THE FILE;
list in 1/20;


#delimit cr


/************************************************************************************************
 NOTES:                                                                                          
                                                                                                 
 1. This program has been tested on Stata Version 10 (for Windows).                              
                                                                                                 
 2. This program will create a permanent Stata dataset.  All additional analyses                 
    can be run using this dataset.  In addition to the dataset, this program creates             
    a log file named H20.LOG and a data file named H20.DTA.  If these files (H20.DTA and H20.LOG)
    already exist in the working directory, they will be replaced when this program is executed. 
                                                                                                 
 3. If the program ends prematurely, the log file will remain open.  Before running this         
    program again, the user should enter the following Stata command: log close                  
                                                                                                 
 4. The cd command assigns C:\MEPS\DATA as the working directory and location of the input       
    ASCII and output .DTA and .LOG files and can be modified by the user as necessary.           
                                                                                                 
 5. Stata commands end with a carriage return by default. The command                            
    #delimit ;                                                                                   
    temporarily changes the command ending delimiter from a carriage return to a semicolon.      
                                                                                                 
 6. The infix command assumes that the input variables are numeric unless the variable name      
    is prefaced by str.  For example, DUPERSID is the a string (or character) variable.          
                                                                                                 
************************************************************************************************/

